/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.GridLayout;
import java.awt.Panel;
import phy.quanta.C60;
import phy.quanta.FullereneLevelViewer;
import phy.quanta.FullereneMolecule;
import phy.quanta.FullereneViewer;

public class DisplayWindow
extends Panel {
    FullereneViewer viewer;
    FullereneLevelViewer levelViewer;
    int xpos;
    int xold;
    FullereneMolecule mol;
    int iVep = 0;
    String mode = "DEMO";
    C60 parent;
    int nAxis = 3;

    FullereneViewer getViewer() {
        return this.viewer;
    }

    public FullereneLevelViewer getLevelViewer() {
        return this.levelViewer;
    }

    DisplayWindow(C60 c60) {
        this.setLayout(new GridLayout(1, 2));
        this.mol = new FullereneMolecule();
        this.viewer = new FullereneViewer(this.mol);
        this.levelViewer = new FullereneLevelViewer(this.mol, this);
        this.add(this.viewer);
        this.add(this.levelViewer);
        this.parent = c60;
    }

    public void vepDown() {
        --this.iVep;
        if (this.iVep < 0) {
            this.iVep = this.mol.nAtomes - 1;
        }
        this.setIVep(this.iVep);
    }

    public void vepUp() {
        ++this.iVep;
        if (this.iVep >= this.mol.nAtomes) {
            this.iVep = 0;
        }
        this.setIVep(this.iVep);
    }

    public void setIVep(int n) {
        this.iVep = n;
        this.levelViewer.setIVep(n);
        this.viewer.setIVep(n);
        this.refresh();
    }

    public void go() {
        this.mol.Diagonalise();
        this.mol.Trie();
        this.refresh();
    }

    public void refresh() {
        this.viewer.repaint();
        this.levelViewer.repaint();
    }
}

