/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import phy.control.HotHLine;
import phy.graphe.BufferedPanel;
import phy.quanta.DisplayWindow;
import phy.quanta.FullereneMolecule;

class FullereneLevelViewer
extends BufferedPanel {
    protected DisplayWindow parent;
    int iVep = 0;
    FullereneMolecule mol;

    public void setIVep(int n) {
        this.iVep = n;
    }

    public FullereneLevelViewer(FullereneMolecule fullereneMolecule, DisplayWindow displayWindow) {
        this.mol = fullereneMolecule;
        this.parent = displayWindow;
    }

    public void paintCore() {
        int n;
        int n2;
        int n3;
        double d = 0.0;
        for (n3 = 0; n3 < this.mol.nAtomes; ++n3) {
            if (!(d < Math.abs(this.mol.vep[n3][this.iVep]))) continue;
            d = Math.abs(this.mol.vep[n3][this.iVep]);
        }
        n3 = 0;
        int n4 = this.getWidth() / 2;
        if (d == 0.0) {
            this.graphics.setColor(Color.yellow);
            int n5 = 3;
            int n6 = 3;
            for (n2 = 0; n2 < this.mol.nAtomes; ++n2) {
                for (n = 0; n < this.mol.nAtomes; ++n) {
                    if (this.mol.hamiltonien[n2][n] == 0.0 || n2 == n) continue;
                    this.graphics.getGraphics().fillRect(this.getWidth() - n5 * this.mol.nAtomes - 50 + n5 * n2, this.getHeight() / 2 - this.mol.nAtomes * n6 / 2 + n6 * n, n5, n6);
                }
            }
        }
        double d2 = 0.0;
        if (d > 0.0) {
            for (n2 = 0; n2 < this.mol.nAtomes; n2 += n) {
                n = 1;
                while (Math.abs(this.mol.vap[n2 + n - 1] - this.mol.vap[n2 + n]) < 0.1 && n2 + n < this.mol.nAtomes) {
                    ++n;
                }
                for (int i = 0; i < n; ++i) {
                    if (n2 + i == this.iVep) {
                        this.graphics.setColor(Color.red);
                        d2 = this.mol.vap[n2];
                    } else {
                        this.graphics.setColor(this.getForeground());
                    }
                    this.graphics.getGraphics().drawLine(this.getWidth() - 80 - n * 7 + i * 14, n4 - (int)(this.mol.vap[n2] / (double)10 * (double)this.getHeight()), this.getWidth() - 80 - n * 7 + i * 14 + 10, n4 - (int)(this.mol.vap[n2] / (double)10 * (double)this.getHeight()));
                }
            }
        }
        this.graphics.setColor(this.getForeground());
        if (d > 0.0) {
            this.graphics.getGraphics().drawString(String.valueOf("E =").concat(String.valueOf(Math.floor(d2 * (double)100) / (double)100)), this.getWidth() - 80 - 30, this.getHeight() - 30);
        }
        this.initHotSpots();
    }

    public void initHotSpots() {
        int n;
        double d = 0.0;
        for (n = 0; n < this.mol.nAtomes; ++n) {
            if (!(d < Math.abs(this.mol.vep[n][this.iVep]))) continue;
            d = Math.abs(this.mol.vep[n][this.iVep]);
        }
        this.getHotSpotVector().removeAllElements();
        n = this.getWidth() / 2;
        if (d > 0.0) {
            int n2;
            for (int i = 0; i < this.mol.nAtomes; i += n2) {
                n2 = 1;
                while (Math.abs(this.mol.vap[i + n2 - 1] - this.mol.vap[i + n2]) < 0.1 && i + n2 < this.mol.nAtomes) {
                    ++n2;
                }
                for (int j = 0; j < n2; ++j) {
                    this.getHotSpotVector().addElement(new HotHLine(this.getWidth() - 80 - n2 * 7 + j * 14, this.getWidth() - 80 - n2 * 7 + j * 14 + 11, n - (int)(this.mol.vap[i] / (double)10 * (double)this.getHeight())));
                }
            }
        }
    }

    public void hotSpotAction(int n) {
        this.parent.setIVep(n);
    }
}

