/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

class FullereneMolecule {
    int nAxis = 3;
    int nAtomes = 60;
    double[][] r = new double[][]{{1.2265, 0.0, 3.3145}, {0.379, 1.1664, 3.3145}, {-0.9922, 0.7209, 3.3145}, {-0.9922, -0.7209, 3.3145}, {0.379, -1.1664, 3.3145}, {3.4084, 0.7209, 0.5948}, {2.7951, 1.1664, 1.8213}, {2.4161, 0.0, 2.5793}, {2.7951, -1.1664, 1.8213}, {3.4084, -0.7209, 0.5948}, {0.3676, 3.4643, 0.5948}, {-0.2456, 3.0188, 1.8213}, {0.7466, 2.2979, 2.5793}, {1.9731, 2.2979, 1.8213}, {1.7389, 3.0188, 0.5948}, {-3.1812, 1.4202, 0.5948}, {-2.9469, 0.6993, 1.8213}, {-1.9547, 1.4202, 2.5793}, {-1.5757, 2.5866, 1.8213}, {-2.3337, 2.5866, 0.5948}, {-2.3337, -2.5866, 0.5948}, {-1.5757, -2.5866, 1.8213}, {-1.9547, -1.4202, 2.5793}, {-2.9469, -0.6993, 1.8213}, {-3.1812, -1.4202, 0.5948}, {1.7389, -3.0188, 0.5948}, {1.9731, -2.2979, 1.8213}, {0.7466, -2.2979, 2.5793}, {-0.2456, -3.0188, 1.8213}, {0.3676, -3.4643, 0.5948}, {0.9922, 0.7209, -3.3145}, {-0.379, 1.1664, -3.3145}, {-1.2265, 0.0, -3.3145}, {-0.379, -1.1664, -3.3145}, {0.9922, -0.7209, -3.3145}, {2.3337, 2.5866, -0.5948}, {1.5757, 2.5866, -1.8213}, {1.9547, 1.4202, -2.5793}, {2.9469, 0.6993, -1.8213}, {3.1812, 1.4202, -0.5948}, {-1.7389, 3.0188, -0.5948}, {-1.9731, 2.2979, -1.8213}, {-0.7466, 2.2979, -2.5793}, {0.2456, 3.0188, -1.8213}, {-0.3676, 3.4643, -0.5948}, {-3.4084, -0.7209, -0.5948}, {-2.7951, -1.1664, -1.8213}, {-2.4161, 0.0, -2.5793}, {-2.7951, 1.1664, -1.8213}, {-3.4084, 0.7209, -0.5948}, {-0.3676, -3.4643, -0.5948}, {0.2456, -3.0188, -1.8213}, {-0.7466, -2.2979, -2.5793}, {-1.9731, -2.2979, -1.8213}, {-1.7389, -3.0188, -0.5948}, {3.1812, -1.4202, -0.5948}, {2.9469, -0.6993, -1.8213}, {1.9547, -1.4202, -2.5793}, {1.5757, -2.5866, -1.8213}, {2.3337, -2.5866, -0.5948}};
    double longueurSeuil = 1.5;
    int nLiaisons;
    int[][] voisin;
    int[][] liaison;
    int nPolyTrouves = 0;
    int nPolygones = 32;
    int[][] polygone;
    double[][] rPoly;
    double[][] hamiltonien;
    double[][] vep;
    double[] vap;

    FullereneMolecule() {
        this.InitData();
        this.InitLiaisons();
        this.InitPolygones();
        this.AlloueMemoire();
        this.InitHamiltonien();
    }

    double Sqr(double d) {
        return d * d;
    }

    double LongueurLiaison(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.nAxis; ++i) {
            d += this.Sqr(this.r[n][i] - this.r[n2][i]);
        }
        return Math.sqrt(d);
    }

    void InitData() {
    }

    void InitLiaisons() {
        int n;
        this.nLiaisons = this.nAtomes * 3 / 2;
        this.liaison = new int[this.nLiaisons][2];
        this.voisin = new int[this.nAtomes][3];
        int[] nArray = new int[this.nAtomes];
        int n2 = 0;
        for (n = 0; n < this.nAtomes; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < this.nAtomes; ++n) {
            for (int i = n + 1; i < this.nAtomes && n2 < this.nLiaisons; ++i) {
                if (!(this.LongueurLiaison(n, i) < this.longueurSeuil)) continue;
                this.liaison[n2][0] = n;
                this.liaison[n2][1] = i;
                ++n2;
                int n3 = n;
                int n4 = nArray[n3];
                nArray[n3] = n4 + 1;
                this.voisin[n][n4] = i;
                int n5 = i;
                int n6 = nArray[n5];
                nArray[n5] = n6 + 1;
                this.voisin[i][n6] = n;
            }
        }
    }

    double ProduitMixte(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        for (int i = 0; i < this.nAxis; ++i) {
            int n = (i + 1) % this.nAxis;
            int n2 = (i + 2) % this.nAxis;
            d += dArray[i] * (dArray2[n] * dArray3[n2] - dArray2[n2] * dArray3[n]);
        }
        return d;
    }

    boolean FaceUp(int n, double[] dArray) {
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        for (int i = 0; i < this.nAxis; ++i) {
            dArray2[i] = this.r[this.polygone[n][1]][i] - this.r[this.polygone[n][0]][i];
            dArray3[i] = this.r[this.polygone[n][2]][i] - this.r[this.polygone[n][1]][i];
        }
        return this.ProduitMixte(dArray2, dArray3, dArray) > 0.0;
    }

    int TrouveAtomeSuivant(int n, int n2) {
        int n3;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (n3 = 0; n3 < this.nAxis; ++n3) {
            dArray[n3] = this.r[n2][n3] - this.r[n][n3];
        }
        for (n3 = 0; n3 < 3; ++n3) {
            int n4 = this.voisin[n2][n3];
            if (n4 == n) continue;
            for (int i = 0; i < this.nAxis; ++i) {
                dArray2[i] = this.r[n4][i] - this.r[n2][i];
            }
            if (!(this.ProduitMixte(dArray, dArray2, this.r[n]) > 0.0)) continue;
            return n4;
        }
        return 0;
    }

    void EssaiePolygone(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[6];
        int[] nArray2 = new int[6];
        nArray[0] = n;
        nArray[1] = n2;
        for (n4 = 2; n4 < 6; ++n4) {
            nArray[n4] = this.TrouveAtomeSuivant(nArray[n4 - 2], nArray[n4 - 1]);
        }
        n4 = 6;
        if (nArray[0] == nArray[5]) {
            n4 = 5;
        }
        int n5 = 0;
        int n6 = this.nAtomes;
        for (n3 = 0; n3 < 6; ++n3) {
            if (nArray[n3] >= n6) continue;
            n5 = n3;
            n6 = nArray[n3];
        }
        for (n3 = 0; n3 < n4; ++n3) {
            nArray2[n3] = nArray[(n3 + n5) % n4];
        }
        for (n3 = 0; n3 < this.nPolyTrouves && (this.polygone[n3][0] != nArray2[0] || this.polygone[n3][1] != nArray2[1]); ++n3) {
        }
        if (n3 == this.nPolyTrouves) {
            for (int i = 0; i < n4; ++i) {
                this.polygone[this.nPolyTrouves][i] = nArray2[i];
            }
            if (n4 == 5) {
                this.polygone[this.nPolyTrouves][5] = nArray2[0];
            }
            ++this.nPolyTrouves;
        }
    }

    void InitPolygones() {
        this.polygone = new int[this.nPolygones][6];
        this.rPoly = new double[this.nPolygones][3];
        int[] nArray = new int[6];
        this.nPolyTrouves = 0;
        for (int i = 0; i < this.nLiaisons && this.nPolyTrouves < this.nPolygones; ++i) {
            this.EssaiePolygone(this.liaison[i][0], this.liaison[i][1]);
            this.EssaiePolygone(this.liaison[i][1], this.liaison[i][0]);
        }
    }

    void AlloueMemoire() {
        int n;
        this.hamiltonien = new double[this.nAtomes][this.nAtomes];
        this.vep = new double[this.nAtomes][this.nAtomes];
        for (n = 0; n < this.nAtomes; ++n) {
            for (int i = 0; i < this.nAtomes; ++i) {
                this.vep[n][i] = 0.0;
            }
        }
        this.vap = new double[this.nAtomes + 1];
        for (n = 0; n < this.nAtomes; ++n) {
            this.vap[n] = 0.0;
        }
    }

    void InitHamiltonien() {
        int n;
        for (n = 0; n < this.nAtomes; ++n) {
            double[] dArray = this.r[n];
            dArray[0] = dArray[0] * 1.001;
        }
        for (n = 0; n < this.nAtomes; ++n) {
            for (int i = 0; i < this.nAtomes; ++i) {
                this.hamiltonien[n][i] = 0.0;
            }
        }
        for (n = 0; n < this.nLiaisons; ++n) {
            double d;
            this.hamiltonien[this.liaison[n][0]][this.liaison[n][1]] = d = (this.LongueurLiaison(this.liaison[n][0], this.liaison[n][1]) - 1.6) * (double)5;
            this.hamiltonien[this.liaison[n][1]][this.liaison[n][0]] = d;
        }
        for (n = 0; n < this.nAtomes; ++n) {
            this.hamiltonien[n][n] = this.r[n][2] / (double)1000;
        }
    }

    void Rotate(double[][] dArray, int n, int n2, int n3, int n4, double d, double d2) {
        double d3 = dArray[n][n2];
        double d4 = dArray[n3][n4];
        dArray[n][n2] = d3 - d * (d4 + d3 * d2);
        dArray[n3][n4] = d4 + d * (d3 - d4 * d2);
    }

    void Diagonalise() {
        int n;
        int n2;
        int n3 = 0;
        double[] dArray = new double[this.nAtomes];
        double[] dArray2 = new double[this.nAtomes];
        for (n2 = 0; n2 < this.nAtomes; ++n2) {
            for (n = 0; n < this.nAtomes; ++n) {
                this.vep[n2][n] = 0.0;
            }
            this.vep[n2][n2] = 1.0;
        }
        for (n2 = 0; n2 < this.nAtomes; ++n2) {
            dArray[n2] = this.vap[n2] = this.hamiltonien[n2][n2];
            dArray2[n2] = 0.0;
        }
        n3 = 0;
        for (int i = 0; i < 50; ++i) {
            double d = 0.0;
            for (n2 = 0; n2 < this.nAtomes - 1; ++n2) {
                for (n = n2 + 1; n < this.nAtomes; ++n) {
                    d += Math.abs(this.hamiltonien[n2][n]);
                }
            }
            if (d == 0.0) {
                return;
            }
            double d2 = i < 4 ? 0.2 * d / (double)(this.nAtomes * this.nAtomes) : 0.0;
            for (n2 = 0; n2 < this.nAtomes - 1; ++n2) {
                for (n = n2 + 1; n < this.nAtomes; ++n) {
                    double d3 = (double)100 * Math.abs(this.hamiltonien[n2][n]);
                    if (i > 4 && Math.abs(this.vap[n2] + d3) == Math.abs(this.vap[n2]) && Math.abs(this.vap[n] + d3) == Math.abs(this.vap[n])) {
                        this.hamiltonien[n2][n] = 0.0;
                    } else if (Math.abs(this.hamiltonien[n2][n]) > d2) {
                        int n4;
                        double d4;
                        double d5 = this.vap[n] - this.vap[n2];
                        if (Math.abs(d5) + d3 == Math.abs(d5)) {
                            d4 = this.hamiltonien[n2][n] / d5;
                        } else {
                            double d6 = 0.5 * d5 / this.hamiltonien[n2][n];
                            d4 = 1.0 / (Math.abs(d6) + Math.sqrt(1.0 + d6 * d6));
                            if (d6 < 0.0) {
                                d4 = -d4;
                            }
                        }
                        double d7 = 1.0 / Math.sqrt(1.0 + d4 * d4);
                        double d8 = d4 * d7;
                        double d9 = d8 / (1.0 + d7);
                        d5 = d4 * this.hamiltonien[n2][n];
                        int n5 = n2;
                        dArray2[n5] = dArray2[n5] - d5;
                        int n6 = n;
                        dArray2[n6] = dArray2[n6] + d5;
                        int n7 = n2;
                        this.vap[n7] = this.vap[n7] - d5;
                        int n8 = n;
                        this.vap[n8] = this.vap[n8] + d5;
                        this.hamiltonien[n2][n] = 0.0;
                        for (n4 = 0; n4 <= n2 - 1; ++n4) {
                            this.Rotate(this.hamiltonien, n4, n2, n4, n, d8, d9);
                        }
                        for (n4 = n2 + 1; n4 <= n - 1; ++n4) {
                            this.Rotate(this.hamiltonien, n2, n4, n4, n, d8, d9);
                        }
                        for (n4 = n + 1; n4 < this.nAtomes; ++n4) {
                            this.Rotate(this.hamiltonien, n2, n4, n, n4, d8, d9);
                        }
                        for (n4 = 0; n4 < this.nAtomes; ++n4) {
                            this.Rotate(this.vep, n4, n2, n4, n, d8, d9);
                        }
                    }
                    ++n3;
                }
            }
            for (n2 = 0; n2 < this.nAtomes; ++n2) {
                int n9 = n2;
                dArray[n9] = dArray[n9] + dArray2[n2];
                this.vap[n2] = dArray[n2];
                dArray2[n2] = 0.0;
            }
        }
    }

    void Trie() {
        int n;
        int n2;
        int[] nArray = new int[this.nAtomes];
        int n3 = 0;
        while (n3 < this.nAtomes) {
            int n4 = 0;
            for (n4 = 0; n4 <= n3 && this.vap[n3] > this.vap[nArray[n4]]; ++n4) {
            }
            for (n2 = n3; n2 > n4; --n2) {
                nArray[n2] = nArray[n2 - 1];
            }
            nArray[n4] = n3++;
        }
        double[] dArray = new double[this.nAtomes];
        double[][] dArray2 = new double[this.nAtomes][this.nAtomes];
        for (n2 = 0; n2 < this.nAtomes; ++n2) {
            dArray[n2] = this.vap[nArray[n2]];
        }
        for (n2 = 0; n2 < this.nAtomes; ++n2) {
            this.vap[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < this.nAtomes; ++n2) {
            for (n = 0; n < this.nAtomes; ++n) {
                dArray2[n2][n] = this.vep[n2][nArray[n]];
            }
        }
        for (n2 = 0; n2 < this.nAtomes; ++n2) {
            for (n = 0; n < this.nAtomes; ++n) {
                this.vep[n2][n] = dArray2[n2][n];
            }
        }
    }
}

