/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.function.Function;
import phy.function.TabulatedFunctionV1;
import phy.graphe.BufferedPanel;
import phy.graphe.Scaler;

class FunctionViewer
extends BufferedPanel {
    TabulatedFunctionV1 function;
    boolean rotated = false;

    Scaler getXScaler() {
        return this.function.getXScaler();
    }

    Scaler getYScaler() {
        return this.function.getYScaler();
    }

    FunctionViewer(Function function) {
        this(new TabulatedFunctionV1(function));
    }

    FunctionViewer(TabulatedFunctionV1 tabulatedFunctionV1) {
        this.function = tabulatedFunctionV1;
    }

    public void sizeHasChanged() {
        if (this.rotated) {
            this.function.getYScaler().setNPixels(this.getWidth());
            this.function.getXScaler().setNPixels(this.getHeight());
        } else {
            this.function.getXScaler().setNPixels(this.getWidth());
            this.function.getYScaler().setNPixels(this.getHeight());
        }
    }

    public void paintCore() {
        if (this.rotated) {
            this.graphics.getGraphics().drawPolyline(this.function.getYArray(), this.function.getXArray(), this.function.getNPoints());
        } else {
            this.graphics.getGraphics().drawPolyline(this.function.getXArray(), this.function.getYArray(), this.function.getNPoints());
        }
    }

    public void setRotated(boolean bl) {
        this.rotated = bl;
    }

    public void refresh() {
        this.function.setValidData(false);
        this.function.update();
        this.repaint();
    }
}

