/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import phy.util.PhysicApplet;

class GraphPanel
extends Canvas {
    double value = 1.0;
    int width;
    int height;
    int x0;
    int y0;
    int w;
    int h;
    Image offscreenImg = null;
    Graphics offscreenG;

    GraphPanel() {
    }

    void setValue(double d) {
        this.value = Math.max(0.0, Math.min(1.0, d));
        this.repaint();
    }

    void drawArrow(Graphics graphics, Point point, Point point2) {
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        float f = point2.x - point.x;
        float f2 = point2.y - point.y;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        if (f3 > (float)10) {
            Point point3 = new Point(point2.x, point2.y);
            Point point4 = new Point(point2.x, point2.y);
            int n = 15;
            if (this.getSize().width < 250) {
                n = 10;
            }
            float f4 = (float)Math.cos(0.39269908169872414);
            float f5 = (float)Math.sin(0.39269908169872414);
            point3.x = (int)((float)point3.x + (float)n * (-f4 * f + f5 * f2) / f3);
            point3.y = (int)((float)point3.y + (float)n * (-f5 * f - f4 * f2) / f3);
            point4.x = (int)((float)point4.x + (float)n * (-f4 * f - f5 * f2) / f3);
            point4.y = (int)((float)point4.y + (float)n * (f5 * f - f4 * f2) / f3);
            int[] nArray = new int[]{point2.x, point3.x, point4.x};
            int[] nArray2 = new int[]{point2.y, point3.y, point4.y};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreenImg == null || this.width != this.getSize().width || this.height != this.getSize().height) {
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            this.offscreenImg = this.createImage(this.width, this.height);
            this.offscreenG = this.offscreenImg.getGraphics();
            this.x0 = this.width / 6;
            this.y0 = this.height - this.height / 6;
            this.w = 4 * this.width / 6;
            this.h = 4 * this.height / 6;
            int n = 0;
            for (int i = 0; i < this.w; ++i) {
                int n2 = this.y0 - (int)(Math.exp(-10.0 * ((double)i + 0.0) / (double)(this.w - 1)) * (double)this.h);
                if (i > 0) {
                    this.offscreenG.drawLine(i + this.x0 - 1, n, i + this.x0, n2);
                }
                n = n2;
            }
            this.drawArrow(this.offscreenG, new Point(this.x0, this.y0), new Point(this.x0 + this.w, this.y0));
            this.drawArrow(this.offscreenG, new Point(this.x0, this.y0), new Point(this.x0, this.y0 - this.h));
            this.offscreenG.drawString(PhysicApplet.getWord("Current"), this.x0 + 5, this.y0 - this.h);
            this.offscreenG.drawString("Distance", this.x0 + this.w - 50, this.y0 - 8);
        }
        graphics.drawImage(this.offscreenImg, 0, 0, this);
        graphics.setColor(Color.red);
        graphics.fillOval((int)(this.value * (double)this.w) + this.x0 - 6, this.y0 - (int)(Math.exp((double)-10 * this.value) * (double)this.h) - 6, 12, 12);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

