/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.quanta.QuantumState;
import phy.util.MathTools;

class HarmonicOscillator1D
implements QuantumState {
    double x0 = 1.0;
    double wx = 1.0;
    double omega = 1.0;
    double phaseShift;
    protected double time;

    HarmonicOscillator1D() {
    }

    public void setOmega(double d) {
        this.omega = d;
    }

    public void setPhaseShift(double d) {
        this.phaseShift = d;
    }

    public void setTime(double d) {
        this.time = d;
        double d2 = d / 8.0 * (double)2 * Math.PI;
        this.x0 = Math.cos(this.omega * d2 + this.phaseShift);
        this.wx = (double)2 * (0.5 - 0.3 * Math.cos((double)2 * (this.omega * d2 + this.phaseShift)));
    }

    public double getValue(double d) {
        return Math.exp(-MathTools.sqr((d - this.x0) / this.wx * (double)4)) / Math.sqrt(this.wx) / (double)3;
    }

    public double getCenter() {
        return this.x0;
    }
}

