/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.MemoryImageSource;
import phy.graphe.BufferedPanel;
import phy.quanta.HarmonicCalculator;

class HarmonicViewer
extends BufferedPanel {
    Image image = null;
    MemoryImageSource imageSource;
    int[] data = null;
    Applet applet;
    Image lowResImage = null;
    MemoryImageSource lowResImageSource;
    int[] lowResData = null;
    int lowResR;
    boolean visuComplex = false;
    double thetaLight = 0.7853981633974483;
    double phiLight = -0.4363323129985824;
    double thetaView = 1.0471975511965976;
    double phiView = 0.7853981633974483;
    double cosThetaView;
    double sinThetaView;
    double cosTheta = 1.0;
    double sinTheta = 0.0;
    int x0;
    int y0;
    int r;
    HarmonicCalculator harmonicCalculator = new HarmonicCalculator();
    protected boolean imageValid = false;

    public void setVisuComplex(boolean bl) {
        this.visuComplex = bl;
    }

    public boolean isVisuComplex() {
        return this.visuComplex;
    }

    public void setImageValid(boolean bl) {
        this.imageValid = bl;
    }

    public boolean isImageValid() {
        return this.imageValid;
    }

    void setPhiView(double d) {
        this.phiView = d;
    }

    HarmonicViewer(Applet applet) {
        this.applet = applet;
        this.harmonicCalculator.setLM(3, 0);
    }

    void computeSines() {
        this.cosThetaView = Math.cos(this.thetaView);
        this.sinThetaView = Math.sin(this.thetaView);
    }

    int xPixel(double d, double d2) {
        return -((int)((double)this.r * Math.sin(d) * Math.sin(d2 - this.phiView)));
    }

    int yPixel(double d, double d2) {
        return (int)((double)this.r * Math.sin(d) * this.cosThetaView * Math.cos(d2 - this.phiView) - (double)this.r * Math.cos(d) * this.sinThetaView);
    }

    void computeData(int[] nArray, int n) {
        long l = System.currentTimeMillis();
        int n2 = 10;
        double d = 0.5;
        this.computeSines();
        int n3 = Color.yellow.getRGB();
        int n4 = this.getBackground().getRGB();
        int n5 = 0;
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                int n6;
                int n7 = n * n - j * j - i * i;
                if (n7 > 0) {
                    double d2;
                    this.cosTheta = Math.sqrt(n7) / (double)n * this.cosThetaView - (double)i * this.sinThetaView / (double)n;
                    this.sinTheta = Math.sqrt(1.0 - this.cosTheta * this.cosTheta);
                    double d3 = Math.atan2(this.sinTheta, this.cosTheta);
                    double d4 = (double)j / this.sinTheta / (double)n;
                    double d5 = ((double)i / (double)n + this.sinThetaView * this.cosTheta) / this.sinTheta / this.cosThetaView;
                    double d6 = Math.atan2(d5, d4) + this.phiView;
                    if (this.isVisuComplex()) {
                        d2 = this.harmonicCalculator.amplitude(d3, d6);
                        double d7 = this.harmonicCalculator.phase(d6);
                        if (d2 < 0.0) {
                            d2 = -d2;
                            d7 += Math.PI;
                        }
                        if (d7 > Math.PI * 2) {
                            d7 -= Math.PI * 2;
                        }
                        d7 = d7 / (double)2 / Math.PI;
                        Color color = Color.getHSBColor((float)d7, 1.0f, (float)d2);
                        n6 = 0xFF000000 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
                    } else {
                        d2 = this.harmonicCalculator.yLM(d3, d6);
                        int n8 = (int)((double)150 * (1.0 - Math.abs(d2)));
                        int n9 = (int)((double)255 * Math.abs(d2)) + n8;
                        n6 = d2 > 0.0 ? n8 << 16 | n9 << 8 | n8 : n9 << 16 | n8 << 8 | n8;
                        n6 |= 0xFF000000 | n6;
                    }
                } else {
                    n6 = 0;
                }
                nArray[n5++] = n6;
            }
        }
        this.setImageValid(true);
    }

    public void refresh() {
        this.setImageValid(false);
        this.repaint();
    }

    void initImage() {
        this.data = new int[(2 * this.r + 1) * (2 * this.r + 1)];
        this.imageSource = new MemoryImageSource(2 * this.r + 1, 2 * this.r + 1, this.data, 0, 2 * this.r + 1);
        this.imageSource.setAnimated(true);
        this.image = this.createImage(this.imageSource);
        this.lowResData = new int[(2 * this.lowResR + 1) * (2 * this.lowResR + 1)];
        this.lowResImageSource = new MemoryImageSource(2 * this.lowResR + 1, 2 * this.lowResR + 1, this.lowResData, 0, 2 * this.lowResR + 1);
        this.lowResImageSource.setAnimated(true);
        this.lowResImage = this.createImage(this.lowResImageSource);
    }

    public void paintCore() {
        super.paintCore();
        long l = System.currentTimeMillis();
        this.x0 = this.getSize().width / 2;
        this.y0 = this.getSize().height / 2;
        this.r = Math.min(this.x0, this.y0) * 5 / 6;
        this.lowResR = Math.min(20, this.r / 2);
        if (this.image == null) {
            this.initImage();
            this.computeData(this.data, this.r);
        }
        if (this.isMouseDown()) {
            if (!this.isImageValid()) {
                this.computeData(this.lowResData, this.lowResR);
                this.lowResImageSource.newPixels();
            }
            this.graphics.setColor(Color.gray);
            this.graphics.getGraphics().fillOval(this.x0 - this.r, this.y0 - this.r, 2 * this.r + 1, 2 * this.r + 1);
            this.graphics.getGraphics().drawImage(this.lowResImage, this.x0 - this.r, this.y0 - this.r, 2 * this.r + 1, 2 * this.r + 1, this);
        } else {
            if (!this.isImageValid()) {
                this.computeData(this.data, this.r);
                this.imageSource.newPixels();
            }
            this.graphics.getGraphics().drawImage(this.image, this.x0 - this.r, this.y0 - this.r, this);
        }
        if (this.isFlagSet("EQ1")) {
            this.graphics.setColor(Color.white);
            if (this.isVisuComplex()) {
                this.graphics.drawTeX("Y_{L,M}(\\theta,\\varphi)", new Point(10, 10), 4);
            } else {
                this.graphics.drawTeX("Y_{L,M}(\\theta,\\varphi)+Y_{L,-M}(\\theta,\\varphi)", new Point(10, 10), 4);
            }
        }
    }

    public void mousePressed() {
        this.setImageValid(false);
        super.mousePressed();
    }

    public void mouseDragged() {
        super.mouseDragged();
        this.phiView += (double)(this.getXMouse() - this.getPrevMousePoint().x) / this.sinThetaView / (double)this.r;
        this.thetaView += -((double)(this.getYMouse() - this.getPrevMousePoint().y)) / (double)this.r;
        this.refresh();
    }

    public void mouseReleased() {
        this.setImageValid(false);
        super.mouseReleased();
    }
}

