/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import phy.acq.Simulator;
import phy.control.HotPoint;
import phy.graphe.BufferedPanel;
import phy.quanta.HarmonicOscillator;
import phy.util.DoublePoint;

public class HarmonicViewerGauge
extends BufferedPanel {
    protected HarmonicOscillator oscillator;
    protected Simulator simulator;

    public void build() {
        this.graphics.setWindow(-0.2, 0.0, 1.3, this.oscillator.getNNiveaux() + 1);
    }

    public HarmonicViewerGauge(Simulator simulator) {
        this.simulator = simulator;
        this.oscillator = (HarmonicOscillator)simulator.getDataSrc();
        this.setMouseActive(true);
        this.graphics.setHMargin(10);
        this.graphics.setVMargin(20);
    }

    public void paintCore() {
        this.graphics.setClipping(true);
        this.graphics.setColor(Color.gray);
        for (int i = 0; i < this.oscillator.getNNiveaux(); ++i) {
            this.graphics.drawHorizontalLineThick(this.graphics.getHPixel(), this.oscillator.weight[i] + this.graphics.getHPixel(), (double)i + 0.5, 7, 7);
        }
        this.graphics.setClipping(false);
        this.graphics.setColor(Color.white);
        this.graphics.drawArrow(new DoublePoint(0.0, 0.0), new DoublePoint(0.0, this.oscillator.getNNiveaux() + 2));
        this.graphics.drawArrow(new DoublePoint(0.0, 0.0), new DoublePoint(1.3, 0.0));
        this.graphics.drawTeX("|C_n|^2", new DoublePoint(1.35, 0.5), 2);
        this.graphics.drawTeX("n", new DoublePoint((double)8 * this.graphics.getHPixel(), (double)(this.oscillator.getNNiveaux() + 2) + (double)2 * this.graphics.getVPixel()), 4);
        this.initHotSpots();
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        for (int i = 0; i < this.oscillator.getNNiveaux(); ++i) {
            this.getHotSpotVector().addElement(new HotPoint(this.xScreen(this.oscillator.weight[i]), this.yScreen((double)i + 0.5), 1));
        }
    }

    public void hotSpotHasMoved(int n) {
        this.oscillator.setCoherentMode(false);
        this.oscillator.weight[n] = Math.max(this.xUser(this.getCurrentHotSpot().getX()), 0.0);
        this.oscillator.computeProba();
        this.simulator.informObservers();
    }

    public void hotSpotReleased(int n) {
        this.oscillator.normalizeWeight();
        this.initHotSpots();
        this.repaint();
    }
}

