/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import phy.control.NavigationPanel;
import phy.control.PhySeparator;
import phy.quanta.HarmonicViewer;
import phy.quanta.QuantaApplet;
import phy.util.PhysicApplet;

public class HarmoniquesSpheriques
extends QuantaApplet
implements ActionListener,
ItemListener {
    HarmonicViewer harmonicViewer;
    long lastTime;
    int defaultL = 15;
    int defaultM = 8;
    boolean showToolBar = false;
    Button plusMButton;
    Button minusMButton;
    Button plusLButton;
    Button minusLButton;
    TextField textFieldL;
    TextField textFieldM;
    protected Checkbox checkbox;

    public HarmoniquesSpheriques(boolean bl) {
        this.setShowToolBar(bl);
    }

    public HarmoniquesSpheriques(boolean bl, int n, int n2) {
        this(bl);
        this.defaultL = n;
        this.defaultM = n2;
    }

    public HarmoniquesSpheriques() {
        this(false);
    }

    public void setShowToolBar(boolean bl) {
        this.showToolBar = bl;
    }

    void getParameters() {
        this.defaultL = this.getParameter("L", this.defaultL);
        this.defaultM = this.getParameter("M", this.defaultM);
        this.showToolBar = this.getParameter("interactif", this.showToolBar);
    }

    public void run() {
        this.lastTime = System.currentTimeMillis();
        while (this.isRunning()) {
            long l = System.currentTimeMillis() - this.lastTime;
            this.harmonicViewer.setPhiView((double)l / 4000.0 * Math.PI + 0.7853981633974483);
            this.harmonicViewer.refresh();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void refreshTextFields() {
        this.textFieldL.setText(String.valueOf("").concat(String.valueOf(this.harmonicViewer.harmonicCalculator.getL())));
        this.textFieldM.setText(String.valueOf("").concat(String.valueOf(this.harmonicViewer.harmonicCalculator.getM())));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (itemEvent.getSource() == this.checkbox) {
            if (this.checkbox.getState()) {
                this.harmonicViewer.setVisuComplex(true);
            } else {
                this.harmonicViewer.setVisuComplex(false);
            }
        }
        this.harmonicViewer.refresh();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        long l = System.currentTimeMillis();
        if (actionEvent.getSource() instanceof Button || actionEvent.getSource() instanceof TextField) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (actionEvent.getSource() instanceof TextField) {
                this.harmonicViewer.harmonicCalculator.setLM(Integer.valueOf(this.textFieldL.getText()), Integer.valueOf(this.textFieldM.getText()));
            } else if (actionEvent.getSource() == this.plusMButton) {
                if (this.harmonicViewer.harmonicCalculator.getM() == this.harmonicViewer.harmonicCalculator.getL()) {
                    this.harmonicViewer.harmonicCalculator.setLM(this.harmonicViewer.harmonicCalculator.getL() + 1, this.harmonicViewer.harmonicCalculator.getM() + 1);
                } else {
                    this.harmonicViewer.harmonicCalculator.setLM(this.harmonicViewer.harmonicCalculator.getL(), this.harmonicViewer.harmonicCalculator.getM() + 1);
                }
            } else if (actionEvent.getSource() == this.minusMButton) {
                if (this.harmonicViewer.harmonicCalculator.getM() == -this.harmonicViewer.harmonicCalculator.getL()) {
                    this.harmonicViewer.harmonicCalculator.setLM(this.harmonicViewer.harmonicCalculator.getL() + 1, this.harmonicViewer.harmonicCalculator.getM() - 1);
                } else {
                    this.harmonicViewer.harmonicCalculator.setLM(this.harmonicViewer.harmonicCalculator.getL(), this.harmonicViewer.harmonicCalculator.getM() - 1);
                }
            } else if (actionEvent.getSource() == this.plusLButton) {
                this.harmonicViewer.harmonicCalculator.setLM(this.harmonicViewer.harmonicCalculator.getL() + 1, this.harmonicViewer.harmonicCalculator.getM());
            } else if (actionEvent.getSource() == this.minusLButton) {
                if (this.harmonicViewer.harmonicCalculator.getM() == -this.harmonicViewer.harmonicCalculator.getL()) {
                    this.harmonicViewer.harmonicCalculator.setLM(this.harmonicViewer.harmonicCalculator.getL() - 1, this.harmonicViewer.harmonicCalculator.getM() + 1);
                } else if (this.harmonicViewer.harmonicCalculator.getM() == this.harmonicViewer.harmonicCalculator.getL()) {
                    this.harmonicViewer.harmonicCalculator.setLM(this.harmonicViewer.harmonicCalculator.getL() - 1, this.harmonicViewer.harmonicCalculator.getM() - 1);
                } else {
                    this.harmonicViewer.harmonicCalculator.setLM(this.harmonicViewer.harmonicCalculator.getL() - 1, this.harmonicViewer.harmonicCalculator.getM());
                }
            }
            this.refreshTextFields();
            this.harmonicViewer.refresh();
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (actionEvent.getActionCommand().equals("COMPLEX")) {
            this.setVisuComplex(true);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void setVisuComplex(boolean bl) {
        this.checkbox.setState(bl);
        this.harmonicViewer.setVisuComplex(bl);
        this.harmonicViewer.refresh();
    }

    public void init() {
        super.init();
        this.getParameters();
        this.setBackground(Color.black);
        this.harmonicViewer = new HarmonicViewer(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.harmonicViewer);
        this.harmonicViewer.harmonicCalculator.setLM(this.defaultL, this.defaultM);
        if (this.showToolBar) {
            this.setToolBar(new NavigationPanel());
            this.checkbox = new Checkbox(PhysicApplet.getWord("Complex"));
            this.getToolBar().add(this.checkbox);
            this.getToolBar().add(new PhySeparator());
            this.getToolBar().add(new Label(" L =", 2));
            this.textFieldL = new TextField("100");
            this.getToolBar().add(this.textFieldL);
            this.plusLButton = new Button("+");
            this.getToolBar().add(this.plusLButton);
            this.minusLButton = new Button("-");
            this.getToolBar().add(this.minusLButton);
            this.getToolBar().add(new PhySeparator());
            this.getToolBar().add(new Label(" M =", 2));
            this.textFieldM = new TextField("-100");
            this.getToolBar().add(this.textFieldM);
            this.plusMButton = new Button("+");
            this.getToolBar().add(this.plusMButton);
            this.minusMButton = new Button("-");
            this.getToolBar().add(this.minusMButton);
            this.getToolBar().add(new PhySeparator());
            this.textFieldL.addActionListener(this);
            this.textFieldM.addActionListener(this);
            this.checkbox.addItemListener(this);
            this.plusMButton.addActionListener(this);
            this.minusMButton.addActionListener(this);
            this.plusLButton.addActionListener(this);
            this.minusLButton.addActionListener(this);
            this.refreshTextFields();
            this.add("South", this.getToolBar());
        }
        this.harmonicViewer.setMouseActive(true);
        this.setDefaultListener(this.harmonicViewer);
    }
}

