/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

public class Hydrogen {
    protected int n = 1;
    protected int l = 0;
    protected double[] coeff;

    public void setN(int n) {
        this.n = n;
        this.init();
    }

    public int getN() {
        return this.n;
    }

    public void setL(int n) {
        this.l = n;
        this.init();
    }

    public int getL() {
        return this.l;
    }

    public Hydrogen() {
        this.init();
    }

    public void init() {
        this.l = Math.min(this.l, this.n - 1);
        this.l = Math.max(this.l, 0);
        int n = this.getN() - this.getL();
        this.coeff = new double[n];
        this.coeff[0] = 1.0;
        int n2 = 0;
        while (n2 + 1 < n) {
            this.coeff[n2 + 1] = (double)-2 * (1.0 - ((double)(this.getL() + n2) + 1.0) / (double)this.getN()) / ((double)n2 + 1.0) / (double)(2 * this.getL() + n2 + 2) * this.coeff[n2];
            ++n2;
        }
    }

    public double getR(double d) {
        double d2 = this.coeff[0];
        double d3 = 1.0;
        for (int i = 1; i < this.getN() - this.getL(); ++i) {
            d2 += (d3 *= d) * this.coeff[i];
        }
        return d2 *= Math.pow(d, this.getL()) * Math.exp(-d / (double)this.getN());
    }
}

