/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import phy.quanta.AbstractControlPanel;
import phy.quanta.ControlPanel;
import phy.quanta.EchoControlPanel;
import phy.quanta.LarmorControlPanel;
import phy.quanta.LarmorWindow;
import phy.quanta.QuantaApplet;
import phy.quanta.SpinControlPanel;

public class Larmor
extends QuantaApplet {
    int mode = 0;
    int autoMode;
    protected LarmorWindow larmorWindow;
    protected AbstractControlPanel controlPanel = null;
    public static int LARMOR = 1;
    public static int RMN = 2;

    public LarmorWindow getLarmorWindow() {
        return this.larmorWindow;
    }

    public AbstractControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public Larmor() {
        this(0);
    }

    public Larmor(int n) {
        this.mode = n;
    }

    void GetParameters() {
        this.mode = this.getParameter("mode", this.mode);
        this.autoMode = this.getParameter("auto", 0);
    }

    public void init() {
        super.init();
        this.GetParameters();
        this.initSimulator();
        this.getSimulator().pause();
        this.getSimulator().getTimer().addActionListener(this);
        this.getSimulator().setTMax(Double.MAX_VALUE);
        this.setLayout(new BorderLayout());
        this.larmorWindow = new LarmorWindow(this, this.mode);
        this.add("Center", this.larmorWindow);
        switch (this.mode) {
            case 0: {
                this.controlPanel = new SpinControlPanel(this);
                break;
            }
            case 1: {
                this.controlPanel = new LarmorControlPanel(this);
                break;
            }
            case 2: {
                this.controlPanel = new ControlPanel(this);
                break;
            }
            case 3: {
                this.controlPanel = new EchoControlPanel(this);
                break;
            }
            case 4: {
                this.controlPanel = new EchoControlPanel(this);
            }
        }
        if (this.controlPanel != null && this.autoMode == 0) {
            this.add("South", this.controlPanel);
            this.setToolBar(this.controlPanel);
        }
        this.larmorWindow.init();
        if (this.autoMode != 0) {
            this.getSimulator().resume();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME")) {
            if (this.getSimulator().isRunning()) {
                this.larmorWindow.Run();
                this.larmorWindow.repaint();
            }
        } else if (actionEvent.getActionCommand().equals("PLAY")) {
            this.controlPanel.actionPerformed(actionEvent);
        } else if (actionEvent.getActionCommand().equals("PAUSE")) {
            this.controlPanel.actionPerformed(actionEvent);
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

