/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import phy.control.HotHLine;
import phy.control.HotSpot;
import phy.dynaplot.PlotWindow;
import phy.quanta.ProbaWindow;

class LevelWindow
extends PlotWindow
implements KeyListener {
    double averageEnergy = 2.5;
    ProbaWindow probaWindow;

    LevelWindow(ProbaWindow probaWindow) {
        this.setWindow(0.0, 0.0, 1.0, 6.0);
        this.probaWindow = probaWindow;
        this.showAxis = false;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addKeyListener(this);
    }

    public void paintCore() {
        super.paintCore();
        this.graphics.setColor(Color.cyan);
        this.graphics.drawLineThick(0.0, 1.0, 1.0, 1.0);
        this.graphics.drawLineThick(0.0, 4.0, 1.0, 4.0);
        this.graphics.setColor(Color.orange);
        this.graphics.drawLine(0.0, this.averageEnergy, 1.0, this.averageEnergy);
        this.graphics.drawStringCB("<E>", 0.5, this.averageEnergy + 0.1);
        this.graphics.setColor(Color.white);
        this.graphics.moveTo(0.0, this.graphics.getY2());
        this.graphics.drawToThick(0.0, this.graphics.getY1());
        this.graphics.drawToThick(1.0, this.graphics.getY1() + 0.001);
        this.graphics.drawToThick(0.999, this.graphics.getY2());
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        this.getHotSpotVector().addElement(new HotHLine(this.xScreen(0.0), this.xScreen(1.0), this.yScreen(this.averageEnergy)));
    }

    public void hotSpotHasMoved(int n) {
        double d = this.yUser(this.getCurrentHotSpot().getY());
        this.averageEnergy = Math.min(4.0, Math.max(1.0, d));
        this.initHotSpots();
        this.refresh();
        this.probaWindow.setEta((this.averageEnergy - 2.5) / 1.5);
        this.probaWindow.computeDataSet();
        this.probaWindow.refresh();
    }

    public void keyPressed(KeyEvent keyEvent) {
        HotSpot hotSpot;
        if (keyEvent.getKeyCode() == 40) {
            HotSpot hotSpot2 = this.getHotSpotVector().getHotSpot(0);
            if (hotSpot2 != null) {
                hotSpot2.setXY(hotSpot2.getX(), hotSpot2.getY() + 1);
                this.setCurrentHotSpotIndex(0);
                this.hotSpotHasMoved(0);
            }
        } else if (keyEvent.getKeyCode() == 38 && (hotSpot = this.getHotSpotVector().getHotSpot(0)) != null) {
            hotSpot.setXY(hotSpot.getX(), hotSpot.getY() - 1);
            this.setCurrentHotSpotIndex(0);
            this.hotSpotHasMoved(0);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

