/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Graphics;
import phy.dynaplot.PlotWindow;
import phy.util.PhysicApplet;

class MarcheWindow
extends PlotWindow {
    public double param = 225.0;

    MarcheWindow() {
        this.endTime = 1000;
        this.prefix = "t =";
        this.suffix = " fs";
        this.scaleFactor = 4.0;
        this.scaleDisplay = 1.0;
    }

    public void paintCorePlot() {
        if (this.dataSet != null && this.dataSet.dataReady) {
            this.graphics.setColor(Color.orange);
            this.graphics.drawLine(this.graphics.getX1(), 200.0, this.graphics.getX2(), 200.0);
            this.graphics.setColor(Color.cyan);
            if (this.param > 0.0) {
                this.graphics.drawLine(this.graphics.getX1(), 0.0, 0.0, 0.0);
                this.graphics.drawLine(0.0, 0.0, 0.0, this.param);
                this.graphics.drawLine(0.0, this.param, this.graphics.getX2(), this.param);
            } else {
                this.graphics.drawLine(this.graphics.getX1(), 0.0, 0.0, 0.0);
                this.graphics.drawLine(0.0, 0.0, 0.0, 225.0);
                this.graphics.drawLine(0.0, 225.0, Math.abs(this.param), 225.0);
                this.graphics.drawLine(Math.abs(this.param), 225.0, Math.abs(this.param), 0.0);
                this.graphics.drawLine(Math.abs(this.param), 0.0, this.graphics.getX2(), 0.0);
            }
        }
        super.paintCorePlot();
    }

    public void updateDataSet() {
        super.updateDataSet();
        this.graphics.setYAxis(0.0, 300.0);
        this.sizeHasChanged();
        this.title = this.param > (double)224 ? String.valueOf(PhysicApplet.getWord("StepHeight")).concat(String.valueOf(" 225 meV")) : (this.param > (double)199 ? String.valueOf(PhysicApplet.getWord("StepHeight")).concat(String.valueOf(" 200 meV")) : (this.param > (double)174 ? String.valueOf(PhysicApplet.getWord("StepHeight")).concat(String.valueOf(" 175 meV")) : (this.param > (double)149 ? String.valueOf(PhysicApplet.getWord("StepHeight")).concat(String.valueOf(" 150 meV")) : (this.param > (double)-6 ? PhysicApplet.getWord("Tunnel2") : PhysicApplet.getWord("Tunnel1")))));
    }

    public void sizeHasChanged() {
        super.sizeHasChanged();
        this.graphics.setWindow(this.graphics.getX1(), 0.0, this.graphics.getX2(), 300.0);
    }

    public boolean setCurveColor(Graphics graphics, int n) {
        graphics.setColor(Color.cyan);
        return true;
    }
}

