/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import phy.control.NavigationPanel;
import phy.control.PhySeparator;
import phy.dynaplot.PlotDataSet;
import phy.quanta.MultiPuitsWindow;
import phy.quanta.QuantaApplet;
import phy.util.CrackedString;
import phy.util.PhysicApplet;

public class MultiPuits
extends QuantaApplet
implements ActionListener,
ItemListener {
    String message = null;
    protected MultiPuitsWindow levelWindow = new MultiPuitsWindow();
    int sleepTime = 50;
    double step = 1.0;
    PlotDataSet dataSet;
    long lastTime = 0L;
    Button startButton;
    Button stopButton;
    Button helpButton;
    Choice choiceMode;
    Choice choicePotential;
    Checkbox checkSym;
    int mode = -1;

    public MultiPuitsWindow getMultiPuitsWindow() {
        return this.levelWindow;
    }

    void getParameters() {
        this.mode = this.getParameter("mode", this.mode);
    }

    public MultiPuits() {
    }

    public MultiPuits(int n) {
        this();
        this.mode = n;
    }

    public void init() {
        super.init();
        this.setBackground(Color.black);
        this.getParameters();
        if (this.mode == 0) {
            this.setToolBar(new NavigationPanel());
            this.choiceMode = new Choice();
            this.getToolBar().add(this.choiceMode);
            this.choiceMode.add(PhysicApplet.getWord("TrialFunction"));
            this.choiceMode.add(PhysicApplet.getWord("ShowLevels"));
            this.choiceMode.add(PhysicApplet.getWord("ShowFunctions"));
            this.choiceMode.select(2);
            this.getToolBar().add(new PhySeparator());
            this.choicePotential = new Choice();
            this.getToolBar().add(this.choicePotential);
            this.choicePotential.add(PhysicApplet.getWord("ConstantPotential"));
            this.choicePotential.add(PhysicApplet.getWord("Step"));
            this.choicePotential.add(PhysicApplet.getWord("SingleWell"));
            this.choicePotential.add(PhysicApplet.getWord("DoubleWell"));
            this.choicePotential.select(3);
            this.choiceMode.addItemListener(this);
            this.choicePotential.addItemListener(this);
            this.getToolBar().add(new PhySeparator());
            this.checkSym = new Checkbox(PhysicApplet.getWord("Sym"));
            this.getToolBar().add(this.checkSym);
            if (this.getMultiPuitsWindow().isSym()) {
                this.checkSym.setState(true);
            }
            this.checkSym.addItemListener(this);
            this.getToolBar().add(new PhySeparator());
        }
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 1));
        panel.add(this.levelWindow);
        this.setDefaultListener(this.levelWindow);
        this.setLayout(new BorderLayout());
        this.add("Center", panel);
        if (this.getToolBar() != null) {
            this.add("South", this.getToolBar());
        }
        switch (this.mode) {
            case 0: {
                this.setPotential(3);
                break;
            }
            case 1: {
                this.setPotential(0);
                this.levelWindow.setMode(0);
                break;
            }
            case 2: {
                this.setPotential(1);
                this.levelWindow.setMode(0);
                break;
            }
            case 3: {
                this.setPotential(2);
                this.levelWindow.setMode(0);
                break;
            }
            case 4: {
                this.setPotential(2);
                this.levelWindow.setMode(1);
                break;
            }
            case 5: {
                this.setPotential(3);
                this.levelWindow.setMode(1);
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.levelWindow.setMode(0);
            }
        }
        if (this.levelWindow.getPuits().getPotentialFunction() != null) {
            this.levelWindow.getPuits().initPotential();
        }
        this.setDefaultListener(this.levelWindow);
    }

    public void resetTime() {
        this.lastTime = System.currentTimeMillis();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().startsWith("XMAX ")) {
            this.getMultiPuitsWindow().setXViewMax(CrackedString.getDouble(actionEvent.getActionCommand(), 1));
            this.getMultiPuitsWindow().repaint();
        } else if (actionEvent.getActionCommand().startsWith("XMIN ")) {
            this.getMultiPuitsWindow().setXViewMin(CrackedString.getDouble(actionEvent.getActionCommand(), 1));
            this.getMultiPuitsWindow().repaint();
        } else if (actionEvent.getActionCommand().startsWith("NLEVELS ")) {
            this.getMultiPuitsWindow().setNLevelsShown(CrackedString.getInt(actionEvent.getActionCommand(), 1));
            this.getMultiPuitsWindow().repaint();
        } else if (actionEvent.getActionCommand().startsWith("ENERGY ")) {
            this.getMultiPuitsWindow().setEnergy(CrackedString.getDouble(actionEvent.getActionCommand(), 1));
            this.getMultiPuitsWindow().doComputation();
            this.getMultiPuitsWindow().repaint();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choiceMode) {
            this.levelWindow.setMode(this.choiceMode.getSelectedIndex());
            this.levelWindow.setComputationValid(false);
            this.levelWindow.doComputation();
            this.levelWindow.refresh();
        } else if (itemEvent.getSource() == this.choicePotential) {
            this.setPotential(this.choicePotential.getSelectedIndex());
            this.levelWindow.setComputationValid(false);
            this.levelWindow.doComputation();
            this.levelWindow.refresh();
        } else if (itemEvent.getSource() == this.checkSym) {
            this.levelWindow.setSym(this.checkSym.getState());
            this.levelWindow.setComputationValid(false);
        }
    }

    public void setPotential(int n) {
        switch (n) {
            case 0: {
                this.levelWindow.puits.setPotential(new double[]{2.0}, new double[]{1.0});
                break;
            }
            case 1: {
                this.levelWindow.puits.setPotential(new double[]{0.0, 2.0}, new double[]{3.0, 0.0});
                break;
            }
            case 2: {
                this.levelWindow.puits.setPotential(new double[]{-0.3, 0.3, 2.0}, new double[]{4.0, 0.0, 4.0});
                break;
            }
            case 3: {
                this.levelWindow.puits.setPotential(new double[]{-0.3, -0.05, 0.05, 0.3, 2.0}, new double[]{3.0, 0.0, 4.0, 0.0, 3.0});
            }
        }
        this.levelWindow.setComputationValid(false);
    }
}

