/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import phy.quanta.MolecularViewer;
import phy.quanta.Molecule;
import phy.quanta.QuantaApplet;

public class NH3
extends QuantaApplet {
    String mdname = null;
    String message = null;
    MolecularViewer molecularViewer;
    Molecule molecule;
    int mode = 0;
    protected double lastTime = 0.0;

    public void init() {
        super.init();
        this.initSimulator();
        this.getSimulator().getTimer().addActionListener(this);
        this.setBackground(Color.black);
        this.mode = this.getParameter("mode", 0);
        this.molecule = new Molecule();
        this.molecule.setCenteredCube(true);
        this.molecule.addVert("N", 0.0f, 0.0f, 0.0f);
        this.molecule.addVert("H", -1.0f, 1.0f, 1.0f);
        this.molecule.addVert("H", 1.0f, -1.0f, 1.0f);
        this.molecule.addVert("H", 1.0f, 1.0f, -1.0f);
        if (this.mode == 1) {
            this.molecule.addVert("H", -1.6666666f, 0.33333334f, 0.33333334f);
            this.molecule.addVert("H", 0.33333334f, -1.6666666f, 0.33333334f);
            this.molecule.addVert("H", 0.33333334f, 0.33333334f, -1.6666666f);
        }
        this.molecularViewer = new MolecularViewer(this.molecule);
        this.molecularViewer.yRot(20.0);
        this.molecularViewer.xRot(20.0);
        this.setLayout(new BorderLayout());
        this.add("Center", this.molecularViewer);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME")) {
            double d = this.getSimulator().getTime();
            if (!this.molecularViewer.isMouseDown()) {
                double d2 = Math.cos(d / 4.0 * Math.PI);
                double d3 = 360.0 * (d - this.lastTime) / 12.0;
                d2 *= d2;
                if (this.molecule.nAtoms() < 5 && this.mode == 0) {
                    float f = (float)((double)2 * d2 / (double)3);
                    float f2 = -1.0f - f;
                    float f3 = 1.0f - f;
                    this.molecule.setAtomPos(1, f2, f3, f3);
                    this.molecule.setAtomPos(2, f3, f2, f3);
                    this.molecule.setAtomPos(3, f3, f3, f2);
                } else if (this.mode == 1) {
                    float f = (float)Math.sqrt(1.0 - d2);
                    float f4 = (float)Math.sqrt(d2);
                    this.molecule.setAtomBrightness(1, f);
                    this.molecule.setAtomBrightness(2, f);
                    this.molecule.setAtomBrightness(3, f);
                    this.molecule.setAtomBrightness(4, f4);
                    this.molecule.setAtomBrightness(5, f4);
                    this.molecule.setAtomBrightness(6, f4);
                }
                this.molecularViewer.yRot(d3);
                this.molecularViewer.repaint();
            }
            this.lastTime = d;
        }
    }
}

