/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.HotPoint;
import phy.graphe.BufferedPanel;
import phy.graphe.Scaler;
import phy.quanta.StationaryState;

class PolarViewer
extends BufferedPanel
implements ActionListener {
    StationaryState state;
    Scaler scalerX = new Scaler();
    Scaler scalerY = new Scaler();

    public PolarViewer(StationaryState stationaryState) {
        this.setCursor(new Cursor(12));
        this.state = stationaryState;
        this.scalerX.setBounds(-1.5, 1.5);
        this.scalerY.setBounds(1.5, -1.5);
    }

    public void sizeHasChanged() {
        int n = Math.min(this.getWidth(), this.getHeight());
        this.scalerX.setNPixels(n);
        this.scalerY.setNPixels(n);
        this.scalerX.translate((this.getWidth() - n) / 2);
        this.scalerY.translate((this.getHeight() - n) / 2);
    }

    public void paintCore() {
        this.graphics.setColor(Color.white);
        this.graphics.drawArrow(new Point(this.scalerX.getI(-1.3), this.scalerY.getI(0.0)), new Point(this.scalerX.getI(1.3), this.scalerY.getI(0.0)));
        this.graphics.drawArrow(new Point(this.scalerX.getI(0.0), this.scalerY.getI(-1.3)), new Point(this.scalerX.getI(0.0), this.scalerY.getI(1.3)));
        this.graphics.getGraphics().drawOval(this.scalerX.getI(-1.0), this.scalerY.getI(1.0), this.scalerX.getDeltaI(2.0), this.scalerY.getDeltaI(-2.0));
        int n = this.scalerX.getI(this.state.getRe());
        int n2 = this.scalerY.getI(this.state.getIm());
        this.graphics.setColor(Color.yellow);
        this.graphics.getGraphics().fillOval(n - 5, n2 - 5, 10, 10);
        this.graphics.setColor(Color.green);
        this.graphics.getGraphics().drawLine(this.scalerX.getI(0.0), this.scalerY.getI(0.0), n, this.scalerY.getI(0.0));
        this.graphics.setColor(Color.orange);
        this.graphics.getGraphics().drawLine(this.scalerX.getI(0.0), this.scalerY.getI(0.0), this.scalerX.getI(0.0), n2);
        this.initHotSpots();
    }

    public void initHotSpots() {
        this.getHotSpotVector().removeAllElements();
        this.getHotSpotVector().addElement(new HotPoint(this.scalerX.getI(this.state.getRe()), this.scalerY.getI(this.state.getIm()), 0));
    }

    public void hotSpotHasMoved(int n) {
        this.state.setState(this.scalerX.getX(this.getCurrentHotSpot().getX()), this.scalerY.getX(this.getCurrentHotSpot().getY()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }
}

