/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Cursor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import phy.control.HotPoint;
import phy.function.Function;
import phy.function.TabulatedFunctionV1;
import phy.graphe.MultiFunctionViewer;
import phy.util.MathTools;
import phy.util.PhysicApplet;

class PotentielViewer
extends MultiFunctionViewer
implements Function {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    int iCursor = -1;
    String nomMolecule;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PotentielViewer(String string) {
        this.nomMolecule = string;
        this.setCursor(new Cursor(12));
        this.addCurve(new TabulatedFunctionV1(this), 0, Color.yellow);
        this.setBackground(this.getBackground());
        this.setShowAxis(true);
        this.setXLabel("Distance");
        this.setYLabel(PhysicApplet.getWord("Energy"));
        if (this.nomMolecule.equals("NH3")) {
            this.getCurve(0).setXBounds(-2.0, 2.0);
            this.getCurve(0).setYBounds(1.0, -0.8);
        } else {
            this.getCurve(0).setXBounds(0.8, 2.0);
            this.getCurve(0).setYBounds(4.0, -3.0);
        }
    }

    public double getValue(double d) {
        if (this.nomMolecule.equals("NH3")) {
            return MathTools.sqr(MathTools.sqr(d)) / (double)2 - MathTools.sqr(d);
        }
        return (double)6 / Math.pow(d, 8.0) - (double)8 / Math.pow(d, 6.0);
    }

    public void initHotSpots() {
        if (this.iCursor < 0) {
            this.iCursor = this.getCurve(0).getXScaler().getI(1.0);
        }
        this.getHotSpotVector().removeAllElements();
        this.getHotSpotVector().addElement(new HotPoint(this.iCursor, this.getCurve(0).getYScaler().getI(this.getCurve(0).getValue(this.iCursor)), 0));
    }

    public void hotSpotHasMoved(int n) {
        Double d = new Double(this.getCurve(0).getXScaler().getX(this.iCursor));
        this.iCursor = this.getCurrentHotSpot().closestPointTo(this.getCurve(0).getXArray(), this.getCurve(0).getYArray());
        this.initHotSpots();
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("Q", d, new Double(this.getCurve(0).getXScaler().getX(this.iCursor)));
    }

    public void paintCore() {
        super.paintCore();
        int n = this.iCursor;
        int n2 = this.getCurve(0).getYScaler().getI(this.getCurve(0).getValue(this.iCursor));
        int n3 = 10;
        this.graphics.setColor(Color.lightGray);
        this.graphics.getGraphics().fillOval(n - n3, n2 - n3, 2 * n3 + 1, 2 * n3 + 1);
        this.graphics.setColor(Color.yellow);
        this.graphics.getGraphics().drawOval(n - n3, n2 - n3, 2 * n3, 2 * n3);
    }
}

