/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import phy.acq.DataObservable;
import phy.acq.DataObserver;
import phy.control.ListDoubleValueMonitor;
import phy.control.ListValueMonitor;
import phy.control.NavigationPanel;
import phy.control.PhySeparator;
import phy.graphe.FunctionViewer;
import phy.quanta.FreeWavePacket;
import phy.quanta.QuantaApplet;
import phy.util.CrackedString;
import phy.util.EnumType;
import phy.util.PhysicApplet;

public class Propa
extends QuantaApplet
implements ActionListener,
DataObserver {
    protected FreeWavePacket wavePacket;
    FunctionViewer functionViewer;
    protected boolean autoRestart = true;
    boolean firstTime = true;
    long lastTime;
    double x1;
    double x2;
    double y1;
    double y2;
    double width = 1.0;
    double theta;
    double t0;
    int nPoints;
    protected ListDoubleValueMonitor widthMonitor;
    protected ListValueMonitor displayTypeMonitor;

    public FreeWavePacket getWavePacket() {
        return this.wavePacket;
    }

    public FunctionViewer getViewer() {
        return this.functionViewer;
    }

    public void setAutoRestart(boolean bl) {
        this.autoRestart = bl;
    }

    public boolean isAutoRestart() {
        return this.autoRestart;
    }

    public void setWidth(int n) {
        this.widthMonitor.select(n);
    }

    void getParameters() {
        this.theta = this.t0 = this.getParameter("T0", 0.0);
        this.x1 = this.getParameter("X1", -5.0);
        this.x2 = this.getParameter("X2", 20.0);
        this.nPoints = this.getParameter("nPoints", 200);
    }

    public void init() {
        super.init();
        this.initSimulator();
        this.getSimulator().pause();
        this.getSimulator().setTMax(Double.MAX_VALUE);
        this.getParameters();
        this.wavePacket = new FreeWavePacket();
        this.wavePacket.setT0(this.t0 / (double)100);
        this.wavePacket.setWidth(this.getParameter("width", 0.5));
        this.wavePacket.setDisplayType(this.getParameter("affichage", 0));
        this.getSimulator().setDataSrc(this.wavePacket);
        this.setLayout(new BorderLayout());
        this.initPlayButton();
        this.setToolBar(new NavigationPanel());
        this.getToolBar().add(this.getPlayButton());
        this.getToolBar().add(new PhySeparator());
        this.getToolBar().add(new Label(String.valueOf(PhysicApplet.getWord("DataShown")).concat(String.valueOf(" :")), 2));
        this.displayTypeMonitor = new ListValueMonitor(this.wavePacket, "DisplayType", new EnumType("|\u03c8|\u00b2/Re \u03c8"));
        this.displayTypeMonitor.setFont(new Font("Arial", 0, 12));
        this.getToolBar().add(this.displayTypeMonitor);
        this.displayTypeMonitor.addPropertyChangeListener(this);
        this.getToolBar().add(new PhySeparator());
        this.getToolBar().add(new Label(String.valueOf(PhysicApplet.getWord("Width")).concat(String.valueOf(" :")), 2));
        this.widthMonitor = new ListDoubleValueMonitor(this.wavePacket, "Width", new EnumType("0.5/1/2"));
        this.widthMonitor.addPropertyChangeListener(this);
        this.getToolBar().add(this.widthMonitor);
        this.getToolBar().add(new PhySeparator());
        this.functionViewer = new FunctionViewer();
        this.functionViewer.setBackground(PhysicApplet.getDefaultBackground());
        this.functionViewer.setXLabel(PhysicApplet.getWord("Position"));
        this.functionViewer.setShowAxis(true);
        this.functionViewer.setXAxis(this.x1, this.x2);
        if (this.wavePacket.getDisplayType() == 0) {
            this.functionViewer.setYAxis(0.0, 1.0);
        } else {
            this.functionViewer.setYAxis(-1.0, 1.0);
        }
        this.functionViewer.setTitle(PhysicApplet.getWord("PropaWP"));
        this.functionViewer.addFunction(this.wavePacket, 0, Color.yellow, 300);
        this.add("Center", this.functionViewer);
        this.add("South", this.getToolBar());
        this.getSimulator().addObserver(this.functionViewer);
        this.getSimulator().addObserver(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("DisplayType")) {
            if (this.wavePacket.getDisplayType() == 0) {
                this.functionViewer.setYAxis(0.0, 1.0);
            } else {
                this.functionViewer.setYAxis(-1.0, 1.0);
            }
            this.functionViewer.refresh();
        } else if (propertyChangeEvent.getPropertyName().equals("Width")) {
            this.getSimulator().reset();
            this.getSimulator().informObservers();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("RESTART")) {
            this.getSimulator().reset();
            this.getSimulator().resume();
        } else if (actionEvent.getActionCommand().startsWith("WIDTH ")) {
            this.setWidth(CrackedString.getInt(actionEvent.getActionCommand(), 1));
        } else if (actionEvent.getActionCommand().startsWith("AUTORESTART ")) {
            if (actionEvent.getActionCommand().equals("AUTORESTART ON")) {
                this.setAutoRestart(true);
            } else {
                this.setAutoRestart(false);
            }
        } else if (actionEvent.getActionCommand().startsWith("DISPLAYTYPE ")) {
            this.displayTypeMonitor.select(CrackedString.getInt(actionEvent.getActionCommand(), 1));
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void update(DataObservable dataObservable) {
        if (this.wavePacket.getPosition() > 17.5 && this.isAutoRestart()) {
            this.getSimulator().reset();
        }
    }
}

