/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.NavigationPanel;
import phy.control.PhyButton;
import phy.dynaplot.PlotDataSet;
import phy.quanta.LevelWindow;
import phy.quanta.ProbaWindow;
import phy.quanta.QuantaApplet;
import phy.util.PhysicApplet;

public class Puits
extends QuantaApplet
implements ActionListener {
    boolean firstTime = true;
    LevelWindow levelWindow;
    ProbaWindow probaWindow;
    Panel toolBar;
    int sleepTime = 50;
    double step = 1.0;
    PlotDataSet dataSet;
    long lastTime = 0L;
    PhyButton phyButton;

    public void init() {
        super.init();
        this.initSimulator();
        this.getSimulator().setTMax(Double.MAX_VALUE);
        this.toolBar = new NavigationPanel();
        this.phyButton = new PhyButton("PAUSE");
        this.toolBar.add(this.phyButton);
        this.phyButton.addActionListener(this);
        this.probaWindow = new ProbaWindow();
        this.probaWindow.setCurvePainted(true);
        this.probaWindow.setWindow(0.0, 0.0, 1.0, 2.0);
        this.levelWindow = new LevelWindow(this.probaWindow);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(this.levelWindow);
        panel.add(this.probaWindow);
        Panel panel2 = new Panel();
        panel2.setBackground(PhysicApplet.getDefaultBackground());
        panel2.setLayout(new GridLayout(1, 3));
        panel2.add(new Panel());
        panel2.add(panel);
        panel2.add(new Panel());
        this.setLayout(new BorderLayout());
        this.add("Center", panel2);
        this.add("South", this.toolBar);
        this.setBackground(Color.black);
        this.getSimulator().getTimer().addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME")) {
            this.probaWindow.theta = this.getSimulator().getTime() / 2.0;
            this.probaWindow.computeDataSet();
            this.probaWindow.refresh();
        } else if (actionEvent.getActionCommand().equals("PLAY")) {
            this.getSimulator().resume();
            this.phyButton.setButtonType("PAUSE");
        } else if (actionEvent.getActionCommand().equals("PAUSE")) {
            this.getSimulator().pause();
            ((PhyButton)actionEvent.getSource()).setButtonType("PLAY");
        }
    }
}

