/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import phy.control.NavigationPanel;
import phy.function.SineFunction;
import phy.quanta.QuantumSuperpositionAbstract;
import phy.quanta.StationaryState;
import phy.quanta.StationaryStateViewer;
import phy.quanta.SuperpositionViewer;

public class QuantumSuperposition
extends QuantumSuperpositionAbstract {
    public void init() {
        super.init();
        this.initSimulator();
        this.getSimulator().pause();
        this.getSimulator().setTMax(Double.MAX_VALUE);
        this.mode = this.getParameter("mode", "super");
        NavigationPanel navigationPanel = new NavigationPanel();
        this.initPlayButton();
        navigationPanel.add(this.getPlayButton());
        if (this.mode.equals("super") || this.mode.equals("un")) {
            this.stationaryState1 = new StationaryState();
            this.stationaryState1.setOmega(1.0);
            if (this.mode.equals("super")) {
                this.stationaryState1.setState(1.0 / Math.sqrt(2.0), 0.0);
            }
            this.viewer1 = new StationaryStateViewer(this.stationaryState1, new SineFunction(1));
        }
        if (this.mode.equals("super") || this.mode.equals("deux")) {
            this.stationaryState2 = new StationaryState();
            this.stationaryState2.setOmega(4.0);
            if (this.mode.equals("super")) {
                this.stationaryState2.setState(1.0 / Math.sqrt(2.0), 0.0);
            }
            this.viewer2 = new StationaryStateViewer(this.stationaryState2, new SineFunction(2));
        }
        this.superposition = new SuperpositionViewer(this.viewer1, this.viewer2);
        if (this.stationaryState1 != null) {
            this.stationaryState1.addActionListener(this.superposition);
        }
        if (this.stationaryState2 != null) {
            this.stationaryState2.addActionListener(this.superposition);
        }
        if (this.mode.equals("super")) {
            this.stationaryState1.setState(1.0 / Math.sqrt(2.0), 0.0);
            this.stationaryState2.setState(1.0 / Math.sqrt(2.0), 0.0);
        }
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(3, 1));
        if (this.viewer1 != null) {
            panel.add(this.viewer1);
        } else {
            panel.add(new Panel());
        }
        if (this.viewer2 != null) {
            panel.add(this.viewer2);
        } else {
            panel.add(new Panel());
        }
        if (this.superposition != null) {
            panel.add(this.superposition);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", panel);
        this.add("South", navigationPanel);
        if (this.viewer1 != null) {
            this.setDefaultListener(this.viewer1);
        }
        this.getSimulator().getTimer().addActionListener(this);
    }
}

