/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.function.Function;
import phy.function.TabulatedFunctionV1;
import phy.graphe.BufferedPanel;
import phy.graphe.MultiFunctionViewer;
import phy.quanta.CartesianViewer;
import phy.quanta.HomotheticFunction;
import phy.quanta.PolarViewer;
import phy.quanta.StationaryState;
import phy.util.PhysicApplet;

public class StationaryStateViewer
extends BufferedPanel
implements ActionListener {
    protected MultiFunctionViewer viewer;
    protected CartesianViewer cartesianViewer;
    PolarViewer polarViewer;
    StationaryState stationaryState;
    HomotheticFunction re;
    HomotheticFunction im;

    public MultiFunctionViewer getViewer() {
        return this.viewer;
    }

    public CartesianViewer getCartesianViewer() {
        return this.cartesianViewer;
    }

    public HomotheticFunction getFunctionRe() {
        return this.re;
    }

    public HomotheticFunction getFunctionIm() {
        return this.im;
    }

    public StationaryState getState() {
        return this.stationaryState;
    }

    public StationaryStateViewer(StationaryState stationaryState, Function function) {
        this.stationaryState = stationaryState;
        this.viewer = new MultiFunctionViewer();
        this.viewer.setBackground(PhysicApplet.getDefaultBackground());
        TabulatedFunctionV1 tabulatedFunctionV1 = new TabulatedFunctionV1(function);
        tabulatedFunctionV1.setMode(1);
        tabulatedFunctionV1.setNPoints(30);
        tabulatedFunctionV1.getXScaler().setBounds(0.0, 1.0);
        tabulatedFunctionV1.getYScaler().setBounds(-1.3, 1.3);
        this.re = new HomotheticFunction(tabulatedFunctionV1, 1.0);
        this.im = new HomotheticFunction(tabulatedFunctionV1, 0.0);
        this.re.getXScaler().setBounds(0.0, 1.0);
        this.re.getYScaler().setBounds(-1.3, 1.3);
        this.im.getXScaler().setBounds(0.0, 1.0);
        this.im.getYScaler().setBounds(-1.3, 1.3);
        this.viewer.addCurve(tabulatedFunctionV1, 1, Color.gray.darker());
        this.viewer.addCurve(this.re, 0, Color.green);
        this.viewer.addCurve(this.im, 0, Color.orange);
        stationaryState.addActionListener(this);
        this.cartesianViewer = new CartesianViewer(stationaryState);
        stationaryState.addActionListener(this.cartesianViewer);
        this.polarViewer = new PolarViewer(stationaryState);
        stationaryState.addActionListener(this.polarViewer);
        this.setLayout(new GridLayout(1, 3));
        this.add(this.viewer);
        this.add(this.cartesianViewer);
        this.add(this.polarViewer);
    }

    public void setTime(double d) {
        this.stationaryState.setTime(d);
        this.re.setRatio(this.stationaryState.getRe());
        this.im.setRatio(this.stationaryState.getIm());
        this.viewer.refresh();
        this.cartesianViewer.repaint();
        this.polarViewer.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("UPDATE")) {
            this.re.setRatio(this.stationaryState.getRe());
            this.im.setRatio(this.stationaryState.getIm());
            this.viewer.refresh();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void refreshAll() {
        this.re.setRatio(this.stationaryState.getRe());
        this.im.setRatio(this.stationaryState.getIm());
        this.viewer.refresh();
        this.cartesianViewer.repaint();
        this.polarViewer.repaint();
    }
}

