/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.quanta.HarmonicCalculator;
import phy.quanta.InvertedIntegratedFunction;
import phy.util.MathTools;

public class ThetaLaw
extends InvertedIntegratedFunction {
    protected HarmonicCalculator harmonicCalculator;
    protected int l;
    protected int m;

    public void setL(int n) {
        this.l = n;
        this.harmonicCalculator.setLM(this.getL(), this.getM());
        this.init();
    }

    public int getL() {
        return this.l;
    }

    public void setM(int n) {
        this.m = n;
        this.harmonicCalculator.setLM(this.getL(), this.getM());
        this.init();
    }

    public int getM() {
        return this.m;
    }

    public double getProbabilityValue(double d) {
        if (this.harmonicCalculator == null) {
            this.harmonicCalculator = new HarmonicCalculator();
        }
        return MathTools.sqr(this.harmonicCalculator.truePLM(Math.cos(d), Math.sin(d))) * Math.sin(d);
    }

    public ThetaLaw() {
        super(0.0, Math.PI);
        this.setL(0);
        this.setM(0);
    }
}

