/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.NavigationPanel;
import phy.dynaplot.PlotDataSet;
import phy.quanta.GraphPanel;
import phy.quanta.QuantaApplet;
import phy.quanta.TunnelPlotWindow;
import phy.quanta.VumeterPanel;

public class Tunnel
extends QuantaApplet
implements ActionListener {
    GridLayout layout = new GridLayout(2, 1);
    int nPoints = 200;
    TunnelPlotWindow plotWindow;
    PlotDataSet dataSet;
    VumeterPanel vumeter;
    GraphPanel graphPanel;
    Panel toolBar;
    Button startButton;
    Button stopButton;
    Panel upperPanel;
    AudioClip audioClip;
    protected int counter = 0;

    public void init() {
        super.init();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        this.initSimulator();
        this.getSimulator().pause();
        this.getSimulator().getTimer().addActionListener(this);
        this.toolBar = new NavigationPanel();
        this.toolBar.setForeground(Color.black);
        this.startButton = new Button("Start");
        this.toolBar.add(this.startButton);
        this.stopButton = new Button("Stop");
        this.toolBar.add(this.stopButton);
        this.startButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.dataSet = new PlotDataSet(1, this.nPoints);
        for (int i = 1; i < this.nPoints; ++i) {
            this.dataSet.zData[0][i] = this.dataSet.zData[0][i - 1] + (Math.random() - 0.5) / (double)3;
        }
        this.plotWindow = new TunnelPlotWindow(this);
        this.upperPanel = new Panel();
        this.vumeter = new VumeterPanel();
        this.graphPanel = new GraphPanel();
        this.upperPanel.setLayout(new GridLayout(1, 2));
        this.upperPanel.add(this.vumeter);
        this.upperPanel.add(this.graphPanel);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(this.upperPanel);
        panel.add(this.plotWindow);
        this.plotWindow.setCursor(new Cursor(12));
        this.setLayout(new BorderLayout());
        this.add("Center", panel);
        this.add("South", this.toolBar);
        try {
            this.audioClip = this.getAudioClip(this.getDocumentBase(), "cloche.au");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void tipHasMoved() {
        this.vumeter.setValue(this.plotWindow.tunnelCurrent());
        this.graphPanel.setValue(0.2 * (this.plotWindow.yTipDouble - this.plotWindow.sampleProfile[this.plotWindow.shiftSample] - (double)2));
        if (this.audioClip != null && this.plotWindow.yTipDouble < this.plotWindow.sampleProfile[this.plotWindow.shiftSample]) {
            this.audioClip.play();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.fillOval(10, 10, 30, 30);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME") && this.getSimulator().isRunning()) {
            ++this.counter;
            if (this.counter > 8) {
                this.counter = 0;
                this.plotWindow.next();
                this.plotWindow.repaint();
                this.tipHasMoved();
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.startButton) {
            this.getSimulator().resume();
        } else if (actionEvent.getSource() == this.stopButton) {
            this.getSimulator().pause();
        }
    }
}

