/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import phy.graphe.BufferedPanel;
import phy.quanta.Tunnel;

class TunnelPlotWindow
extends BufferedPanel {
    int x0;
    int xTip = 20;
    int yTip = 20;
    int lastYTip = -1;
    double yTipDouble = 50.0;
    boolean flagMouseDown = false;
    boolean flagMouseEntered = false;
    Point anchorMouse;
    double anchorTip;
    Image sampleImg = null;
    int shiftSample = 0;
    int nPoints;
    double[] sampleProfile = null;
    Tunnel tunnel;

    public TunnelPlotWindow(Tunnel tunnel) {
        this.tunnel = tunnel;
        this.enableEvents(48L);
    }

    double tunnelCurrent() {
        if (this.sampleProfile != null && this.shiftSample < this.nPoints) {
            return (double)5 * Math.exp(-(this.yTipDouble - this.sampleProfile[this.shiftSample]));
        }
        return 0.0;
    }

    void computeYTip() {
        int n = this.getHeight() / 10;
        this.yTip = this.getHeight() - n - this.getHeight() / 6 - n - (int)this.yTipDouble;
    }

    void computeSampleProfile() {
        int n;
        int n2;
        this.sampleProfile[0] = 1.0;
        for (n2 = 1; n2 < this.nPoints; ++n2) {
            this.sampleProfile[n2] = this.sampleProfile[n2 - 1] + (Math.random() - 0.5) / (double)3;
        }
        for (n2 = 2; n2 < this.nPoints; ++n2) {
            this.sampleProfile[n2] = this.sampleProfile[n2] * 0.4 + this.sampleProfile[n2 - 1] * 0.3 + this.sampleProfile[n2 - 2] * 0.3;
        }
        double d = 1000.0;
        double d2 = -1000.0;
        for (n = 0; n < this.nPoints; ++n) {
            d = Math.min(d, this.sampleProfile[n]);
            d2 = Math.max(d2, this.sampleProfile[n]);
        }
        for (n = 0; n < this.nPoints; ++n) {
            this.sampleProfile[n] = (this.sampleProfile[n] - d) / (d2 - d) * (double)this.getHeight() / (double)7;
        }
        this.yTipDouble = this.sampleProfile[0] + (double)5;
        this.computeYTip();
        this.tunnel.tipHasMoved();
    }

    void next() {
        if (this.shiftSample < this.nPoints - 1) {
            this.yTipDouble = Math.max(this.yTipDouble, this.sampleProfile[this.shiftSample] + 1.0);
            this.computeYTip();
            Graphics graphics = this.sampleImg.getGraphics();
            if (this.shiftSample % 10 == 0) {
                graphics.setColor(Color.yellow.brighter().brighter());
                graphics.fillRect(this.shiftSample + this.getWidth() / 15, 0, 10, 2 * this.getHeight() / 5);
                graphics.setColor(Color.black);
                graphics.fillRect(this.shiftSample + this.getWidth() / 15 + 4, 2, this.getHeight() / 40, this.getHeight() / 40);
                graphics.fillRect(this.shiftSample + this.getWidth() / 15 + 4, 2 * this.getHeight() / 5 - 2 - this.getHeight() / 40, this.getHeight() / 40, this.getHeight() / 40);
            }
            graphics.setColor(Color.blue);
            if (this.lastYTip > 0) {
                graphics.drawLine(this.shiftSample + this.getWidth() / 15 - 1, this.lastYTip - 2 * this.getHeight() / 5, this.shiftSample + this.getWidth() / 15, this.yTip - 2 * this.getHeight() / 5);
            }
            this.lastYTip = this.yTip;
            ++this.shiftSample;
        }
    }

    void drawSampleImg() {
        int n = this.getHeight() / 10;
        this.sampleImg = this.createImage(this.getWidth(), this.getHeight());
        Graphics graphics = this.sampleImg.getGraphics();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.x0, this.getHeight() - n - this.getHeight() / 6, this.getWidth() - 2 * this.x0, this.getHeight() / 6);
        graphics.setColor(Color.green);
        for (int i = 0; i < this.nPoints; ++i) {
            graphics.drawLine(this.getWidth() / 15 + i, this.getHeight() - n - this.getHeight() / 6, this.getWidth() / 15 + i, this.getHeight() - n - this.getHeight() / 6 - n - (int)this.sampleProfile[i]);
        }
    }

    void drawTip(Graphics graphics) {
        int n = this.getHeight() / 4;
        int n2 = n / 2;
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.xTip + 4, this.yTip - 2 * this.getHeight() / 5 - 4, 4, 2 * this.getHeight() / 5 - n / 2);
        graphics.fillPolygon(new int[]{this.xTip, this.xTip + 4, this.xTip + 4}, new int[]{this.yTip - 2 * this.getHeight() / 5, this.yTip - 2 * this.getHeight() / 5 - 4, this.yTip - 2 * this.getHeight() / 5 + 4}, 3);
        Graphics graphics2 = graphics.create(this.xTip - n2 / 2, this.yTip - n, n2 + 1, n + 1);
        Color color = Color.black;
        Color color2 = Color.cyan;
        if (this.flagMouseDown) {
            color2 = Color.yellow;
        } else if (this.flagMouseEntered) {
            color2 = Color.red;
        }
        graphics2.setColor(color2);
        graphics2.fillPolygon(new int[]{0, n2 / 2, n2}, new int[]{n - n / 2, n - n / 4 + 5, n - n / 2}, 3);
        graphics2.setColor(color);
        graphics2.drawPolygon(new int[]{0, n2 / 2, n2}, new int[]{n - n / 2, n - n / 4 + 5, n - n / 2}, 3);
        graphics2.setColor(color2);
        graphics2.fillOval(0, n - n / 2 - 4, n2 - 1, 8);
        graphics2.setColor(color);
        graphics2.drawOval(0, n - n / 2 - 4, n2 - 1, 8);
        graphics2.setColor(color2);
        graphics2.fillRect(0, 4, n2, n / 2 - 4);
        graphics2.setColor(color);
        graphics2.drawLine(0, 4, 0, n / 2);
        graphics2.drawLine(n2, 4, n2, n / 2);
        graphics2.setColor(color2);
        graphics2.fillOval(0, 0, n2 - 1, 8);
        graphics2.setColor(color);
        graphics2.drawOval(0, 0, n2 - 1, 8);
        graphics2.setColor(color2);
        graphics2.fillPolygon(new int[]{n2 / 2 - 2, n2 / 2, n2 / 2 + 2}, new int[]{n - n / 4, n, n - n / 4}, 3);
        graphics2.setColor(color);
        graphics2.drawPolyline(new int[]{n2 / 2 - 2, n2 / 2, n2 / 2 + 2}, new int[]{n - n / 4, n, n - n / 4}, 3);
    }

    public void sizeHasChanged() {
        System.out.println(String.valueOf(String.valueOf(String.valueOf("Size changed ").concat(String.valueOf(this.getWidth()))).concat(String.valueOf(" "))).concat(String.valueOf(this.getHeight())));
        this.x0 = this.getWidth() / 30;
        this.shiftSample = 0;
        this.xTip = this.getWidth() - this.getWidth() / 7;
        this.computeYTip();
        this.nPoints = this.getWidth() - this.getWidth() / 10;
        this.sampleProfile = new double[this.nPoints];
        this.computeSampleProfile();
        this.drawSampleImg();
    }

    public void paintCore() {
        this.graphics.getGraphics().drawImage(this.sampleImg, this.xTip - this.getWidth() / 15 - this.shiftSample, 0, this);
        this.drawTip(this.graphics.getGraphics());
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.mousePressed(mouseEvent);
        } else if (mouseEvent.getID() == 502) {
            this.mouseReleased(mouseEvent);
        } else if (mouseEvent.getID() == 504) {
            this.mouseEntered(mouseEvent);
        } else if (mouseEvent.getID() == 505) {
            this.mouseExited(mouseEvent);
        }
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            this.mouseDragged(mouseEvent);
        } else if (mouseEvent.getID() == 503) {
            this.mouseMoved(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.flagMouseDown = true;
        this.anchorMouse = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.anchorTip = this.yTipDouble;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.flagMouseDown = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.flagMouseDown) {
            this.yTipDouble = this.anchorTip - (double)(mouseEvent.getY() - this.anchorMouse.y) / 5.0;
            this.yTipDouble = Math.max(this.yTipDouble, this.sampleProfile[this.shiftSample] + 1.0);
            this.computeYTip();
            this.repaint();
            this.tunnel.tipHasMoved();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.flagMouseEntered = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.flagMouseEntered = false;
        this.repaint();
    }
}

