/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import phy.function.Curve;
import phy.graphe.BufferedPanel;
import phy.graphe.FunctionViewer;
import phy.util.PhysicApplet;

class YoungPanel
extends BufferedPanel {
    double taux = 1.0;
    public int nFranges;
    boolean clearData = true;
    long lastTime;
    public int leftInset = 0;
    public int rightInset = 0;
    protected FunctionViewer plotWindow;
    protected Curve curve;
    int nChannels = 0;
    public int nAtoms;
    public double maxCount;
    public boolean useMouse = true;
    public int atomSize = 1;
    int width = -1;
    int height = -1;
    protected boolean paused = false;

    public FunctionViewer getPlotWindow() {
        return this.plotWindow;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.resetTime();
        this.paused = false;
    }

    public YoungPanel(double d, int n) {
        this.setBackgroundInUse(true);
        this.taux = d;
        this.nFranges = n;
        this.resetTime();
        this.curve = new Curve();
        this.plotWindow = new FunctionViewer();
        this.plotWindow.setBackground(this.getBackground());
        this.plotWindow.setRoundAxis(false);
        this.plotWindow.setYAxis(0.0, 2.0);
        this.plotWindow.setShowAxis(true);
        this.plotWindow.setXLabel(PhysicApplet.getWord("IChanel"));
        this.plotWindow.setYLabel(PhysicApplet.getWord("NShots"));
        this.plotWindow.addCurve(this.getCurve(), 1, Color.yellow);
    }

    public void resetTime() {
        this.lastTime = System.currentTimeMillis();
    }

    public double RandomX(int n) {
        int n2;
        double d = 3.141592653;
        double d2 = Math.random();
        double d3 = 1.0;
        double d4 = 1.0;
        if (d2 < 0.005) {
            d3 = Math.exp(Math.log((double)6 * d2 / d / d) / (double)3);
        } else {
            for (n2 = 0; n2 < 10; ++n2) {
                d3 += (d2 - d4) / (1.0 - Math.cos(d * d3));
                d4 = d3 - Math.sin(d * d3) / d;
            }
        }
        if (Math.random() > 0.5) {
            d3 = (double)2 - d3;
        }
        n2 = (int)(Math.random() * (double)this.nFranges);
        return (d3 / (double)2 + (double)n2) / (double)this.nFranges * (double)n;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void sizeHasChanged() {
        this.nChannels = this.getWidth() - this.leftInset - this.rightInset;
        this.clearData = true;
        this.plotWindow.setXAxis(0.0, this.nChannels);
    }

    public void paintCore() {
        Graphics graphics = this.graphics.getGraphics();
        int n = this.getSize().width - this.leftInset - this.rightInset;
        if (this.clearData) {
            this.setBackgroundInUse(true);
            this.resetTime();
            this.clearData = false;
            this.backgroundGraphics.setColor(this.getBackground());
            this.backgroundGraphics.getGraphics().fillRect(this.leftInset, 0, this.nChannels, this.getSize().height - 1);
            graphics.setColor(Color.white);
            graphics.drawRect(this.leftInset, 0, this.nChannels, this.getSize().height - 1);
            this.backgroundGraphics.setColor(Color.white);
            this.backgroundGraphics.getGraphics().drawRect(this.leftInset, 0, this.nChannels, this.getSize().height - 1);
            this.curve.setNPoints(this.nChannels);
            this.curve.calibrate(1.0, this.nChannels);
            this.maxCount = 1.0;
        }
        if (this.paused) {
            return;
        }
        long l = System.currentTimeMillis();
        int n2 = (int)((double)(l - this.lastTime) * this.taux / 1000.0);
        if (n2 > 0) {
            this.lastTime = l;
        }
        n2 = Math.min(n2, 2000);
        graphics.setColor(Color.yellow);
        this.backgroundGraphics.setColor(Color.yellow);
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)this.RandomX(this.nChannels - 1);
            int n4 = (int)(Math.random() * (double)(this.getSize().height - 2));
            double[] dArray = this.curve.getYArray();
            int n5 = n3;
            dArray[n5] = dArray[n5] + 1.0;
            this.maxCount = Math.max(this.maxCount, this.curve.getY(n3));
            graphics.fillRect(n3 + 1 + this.leftInset - this.atomSize / 2, n4 + 1 - this.atomSize / 2, this.atomSize, this.atomSize);
            this.backgroundGraphics.getGraphics().fillRect(n3 + 1 + this.leftInset - this.atomSize / 2, n4 + 1 - this.atomSize / 2, this.atomSize, this.atomSize);
        }
        this.nAtoms += n2;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.useMouse) {
            this.clearData = true;
            return true;
        }
        return false;
    }

    public void setRate(double d) {
        this.taux = d;
    }

    public void setFranges(int n) {
        this.nFranges = n;
        this.clearData = true;
    }

    public void reset() {
        this.clearData = true;
        this.maxCount = 1.0;
    }
}

