/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import java.awt.Point;
import phy.util.Interval;
import phy.util.Unit;

public class MathTools {
    protected static char decimalPoint = (char)44;

    public static int sqr(int n) {
        return n * n;
    }

    public static double sqr(double d) {
        return d * d;
    }

    public static double cube(double d) {
        return d * d * d;
    }

    public static int sign(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public static int[] getRamp(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public static int[] getIntArray(double[] dArray, double d) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)Math.rint(dArray[i] * d);
        }
        return nArray;
    }

    public static double min(double d, double d2, double d3) {
        return Math.min(d, Math.min(d2, d3));
    }

    public static int min(int n, int n2, int n3) {
        return Math.min(n, Math.min(n2, n3));
    }

    public static double max(double d, double d2, double d3) {
        return Math.max(d, Math.max(d2, d3));
    }

    public static int max(int n, int n2, int n3) {
        return Math.max(n, Math.max(n2, n3));
    }

    public static double minMax(double d, double d2, double d3) {
        return Math.min(d3, Math.max(d2, d));
    }

    public static int minMax(int n, int n2, int n3) {
        return Math.min(n3, Math.max(n2, n));
    }

    public static double minMax(double d, Interval interval) {
        if (interval != null) {
            return MathTools.minMax(d, interval.a, interval.b);
        }
        return d;
    }

    public static String formatte(int n, int n2, char c) {
        String string = String.valueOf("").concat(String.valueOf(n));
        if (string.length() >= n2) {
            return string.substring(string.length() - n2, string.length());
        }
        while (string.length() < n2) {
            string = String.valueOf(c).concat(String.valueOf(string));
        }
        return string;
    }

    public static String formatte(double d) {
        double d2 = d * 1.0E-5;
        if (d2 == 0.0) {
            d2 = 1.0E-5;
        }
        if (Math.abs(d - Math.rint(d)) < d2) {
            return MathTools.formatte(d, 0);
        }
        String string = String.valueOf("").concat(String.valueOf(d));
        int n = string.indexOf(".");
        if (n >= 0) {
            string = String.valueOf(String.valueOf(string.substring(0, n)).concat(String.valueOf(MathTools.getDecimalPoint()))).concat(String.valueOf(string.substring(n + 1)));
        }
        return string;
    }

    public static String formatte(double d, int n) {
        if (n < 0) {
            return MathTools.formatte(d);
        }
        double d2 = 1.0;
        if (n > 0) {
            d2 = Math.pow(10.0, n);
        }
        String string = "";
        if (d < 0.0) {
            string = "-";
            d = Math.abs(d);
        }
        String string2 = Integer.toString((int)Math.rint(d * d2));
        if (n == 0) {
            return String.valueOf(string).concat(String.valueOf(string2));
        }
        if (string2.length() > n) {
            return String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf(string2.substring(0, string2.length() - n)))).concat(String.valueOf(MathTools.getDecimalPoint()))).concat(String.valueOf(string2.substring(string2.length() - n)));
        }
        String string3 = String.valueOf("0").concat(String.valueOf(MathTools.getDecimalPoint()));
        for (int i = 0; i < n - string2.length(); ++i) {
            string3 = String.valueOf(string3).concat(String.valueOf("0"));
        }
        return String.valueOf(String.valueOf(string).concat(String.valueOf(string3))).concat(String.valueOf(string2));
    }

    public static char getDecimalPoint() {
        return decimalPoint;
    }

    public static void setDecimalPoint(char c) {
        decimalPoint = c;
    }

    public static String formatte(double d, int n, int n2) {
        String string = MathTools.formatte(d, n);
        int n3 = 2 * string.length();
        if (string.indexOf(MathTools.getDecimalPoint()) >= 0) {
            --n3;
        }
        if (string.indexOf("-") >= 0) {
            --n3;
        }
        if (string.indexOf("+") >= 0) {
            --n3;
        }
        for (int i = n3; i < 2 * n2; ++i) {
            string = String.valueOf(" ").concat(String.valueOf(string));
        }
        return string;
    }

    public static String unitFormatte(double d, String string, int n) {
        if (d == 0.0) {
            return String.valueOf(String.valueOf(MathTools.formatte(d, n)).concat(String.valueOf(" "))).concat(String.valueOf(string));
        }
        int n2 = (int)Math.floor(MathTools.log10(d * 1.000001) / (double)3);
        return String.valueOf(String.valueOf(String.valueOf(MathTools.formatte(d * Math.pow(10.0, -3 * n2), n)).concat(String.valueOf(" "))).concat(String.valueOf(Unit.getPrefix(n2)))).concat(String.valueOf(string));
    }

    public static String halfByteFormatte(int n) {
        switch (n) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 3: {
                return "3";
            }
            case 4: {
                return "4";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 9: {
                return "9";
            }
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
        }
        return "X";
    }

    public static String byteFormatte(byte by) {
        return String.valueOf(MathTools.halfByteFormatte((by & 0xF0) >> 4)).concat(String.valueOf(MathTools.halfByteFormatte(by & 0xF)));
    }

    public static double doubleValue(String string) {
        return Double.valueOf(string);
    }

    public static double parseDouble(String string) {
        int n = string.indexOf(",");
        if (n >= 0) {
            string = String.valueOf(String.valueOf(string.substring(0, n)).concat(String.valueOf("."))).concat(String.valueOf(string.substring(n + 1)));
        }
        double d = 0.0;
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(String.valueOf("Erreur en convertissant ").concat(String.valueOf(string))).concat(String.valueOf(" en double")));
        }
        return d;
    }

    public static byte getByteValue(String string) {
        if (string.length() == 1) {
            char c = string.charAt(0);
            switch (c) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': {
                    return 10;
                }
                case 'B': {
                    return 11;
                }
                case 'C': {
                    return 12;
                }
                case 'D': {
                    return 13;
                }
                case 'E': {
                    return 14;
                }
                case 'F': {
                    return 15;
                }
            }
            return 0;
        }
        if (string.length() == 2) {
            return (byte)((MathTools.getByteValue(string.substring(0, 1)) << 4) + MathTools.getByteValue(string.substring(1)));
        }
        return 0;
    }

    public static byte[] makeByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            byArray[i] = MathTools.getByteValue(string.substring(i * 2, (i + 1) * 2));
        }
        return byArray;
    }

    public static double getDoubleValue(Object object) {
        return (Double)object;
    }

    public static int intValue(String string) {
        try {
            int n = Integer.valueOf(string);
            return n;
        }
        catch (Exception exception) {
            int n = 0;
            return n;
        }
    }

    public static int getIntValue(Object object) {
        return (Integer)object;
    }

    public static double frac(double d) {
        return d - Math.floor(d);
    }

    public static int rint(double d) {
        return (int)Math.rint(d);
    }

    public static boolean belongs(double d, double d2, double d3) {
        return d < Math.max(d2, d3) && d > Math.min(d2, d3);
    }

    public static long getUsedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static double distance(Point point, Point point2) {
        return Math.sqrt(MathTools.sqr(point2.x - point.x) + MathTools.sqr(point2.y - point.y));
    }
}

