/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

public class Point3D {
    public double x;
    public double y;
    public double z;

    public Point3D() {
    }

    public Point3D(Point3D point3D) {
        this(point3D.x, point3D.y, point3D.z);
    }

    public Point3D(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void setData(int n, double d) {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            case 2: {
                this.z = d;
            }
        }
    }

    public double getData(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return 0.0;
    }

    public void sub(Point3D point3D) {
        this.x -= point3D.x;
        this.y -= point3D.y;
        this.z -= point3D.z;
    }

    public void add(Point3D point3D) {
        this.x += point3D.x;
        this.y += point3D.y;
        this.z += point3D.z;
    }

    public void mul(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public double sqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double norm() {
        return Math.sqrt(this.sqr());
    }

    public void normalize() {
        double d = Math.sqrt(this.sqr());
        if (d > 0.0) {
            this.x /= d;
            this.y /= d;
            this.z /= d;
        }
    }

    public void orthonormalize(Point3D point3D) {
        this.sub(Point3D.mul(point3D, Point3D.scalarProduct(this, point3D)));
        this.normalize();
    }

    public static double scalarProduct(Point3D point3D, Point3D point3D2) {
        double d = 0.0;
        for (int i = 0; i < 3; ++i) {
            d += point3D.getData(i) * point3D2.getData(i);
        }
        return d;
    }

    public static Point3D mul(Point3D point3D, double d) {
        Point3D point3D2 = new Point3D(point3D);
        point3D2.mul(d);
        return point3D2;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[").concat(String.valueOf(this.x))).concat(String.valueOf(","))).concat(String.valueOf(this.y))).concat(String.valueOf(","))).concat(String.valueOf(this.z))).concat(String.valueOf("]"));
    }
}

