/*
 * Decompiled with CFR 0.152.
 */
package phy.util;

import phy.util.DoublePoint;
import phy.util.Point3D;
import phy.util.Polygon3D;
import phy.util.Vector3D;

public class RotationMatrix {
    protected double[][] mat = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};

    public RotationMatrix() {
    }

    public RotationMatrix(double[][] dArray) {
        this.mat = dArray;
    }

    public RotationMatrix(RotationMatrix rotationMatrix) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mat[i][j] = rotationMatrix.mat[i][j];
            }
        }
    }

    public void clear() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mat[i][j] = 0.0;
            }
        }
    }

    public void init() {
        this.clear();
        this.mat[2][2] = 1.0;
        this.mat[1][1] = 1.0;
        this.mat[0][0] = 1.0;
    }

    public Vector3D mul(Point3D point3D) {
        Vector3D vector3D = new Vector3D();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                vector3D.setData(i, vector3D.getData(i) + this.mat[i][j] * point3D.getData(j));
            }
        }
        return vector3D;
    }

    public Vector3D inverseMul(Point3D point3D) {
        Vector3D vector3D = new Vector3D();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                vector3D.setData(i, vector3D.getData(i) + this.mat[j][i] * point3D.getData(j));
            }
        }
        return vector3D;
    }

    public void mul(RotationMatrix rotationMatrix) {
        RotationMatrix rotationMatrix2 = new RotationMatrix(this);
        this.clear();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = this.mat[i];
                    int n = j;
                    dArray[n] = dArray[n] + rotationMatrix.mat[i][k] * rotationMatrix2.mat[k][j];
                }
            }
        }
    }

    public void xRotate(double d) {
        this.mul(RotationMatrix.makeXRotationMatrix(d));
    }

    public void yRotate(double d) {
        this.mul(RotationMatrix.makeYRotationMatrix(d));
    }

    public static RotationMatrix makeXRotationMatrix(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.mat[1][1] = d2;
        rotationMatrix.mat[2][2] = d2;
        rotationMatrix.mat[1][2] = d3;
        rotationMatrix.mat[2][1] = -d3;
        return rotationMatrix;
    }

    public static RotationMatrix makeYRotationMatrix(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.mat[0][0] = d2;
        rotationMatrix.mat[2][2] = d2;
        rotationMatrix.mat[0][2] = d3;
        rotationMatrix.mat[2][0] = -d3;
        return rotationMatrix;
    }

    public DoublePoint project(Point3D point3D, Point3D point3D2) {
        Point3D point3D3 = new Point3D(point3D);
        point3D3.sub(point3D2);
        point3D3 = this.mul(point3D3);
        return new DoublePoint(point3D3.x, point3D3.y);
    }

    public DoublePoint[] project(Polygon3D polygon3D, Point3D point3D) {
        DoublePoint[] doublePointArray = new DoublePoint[polygon3D.getSize()];
        for (int i = 0; i < polygon3D.getSize(); ++i) {
            doublePointArray[i] = this.project(polygon3D.getPoint(i), point3D);
        }
        return doublePointArray;
    }
}

