/*
 * Decompiled with CFR 0.152.
 */
package phy.applet;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import phy.applet.AppletHolder;
import phy.control.HorizontalGauge;
import phy.util.AbsoluteLayout;
import phy.util.Interval;
import phy.util.SoundPlayer;
import phy.util.TimeEvent;

public class AppletHolderGauge
extends AppletHolder {
    protected Panel toolBar = new Panel();
    protected HorizontalGauge gauge;
    protected Button startStopButton;
    protected int widthGauge = 200;

    public AppletHolderGauge() {
        this.toolBar.setBackground(Color.black);
        this.gauge = new HorizontalGauge();
        this.toolBar.setLayout(new AbsoluteLayout());
        this.startStopButton = new Button("STOP");
        this.startStopButton.setCursor(new Cursor(12));
        this.startStopButton.addActionListener(this);
        this.toolBar.add((Component)this.startStopButton, new Rectangle(250, 6, 100, 22));
    }

    public void init() {
        super.init();
        if (!this.autoRun) {
            this.startStopButton.setLabel("START");
        }
        String string = this.getParameter("timeLineEnd");
        long l = 0L;
        if (string != null) {
            l = Integer.valueOf(string).longValue();
            this.gauge.setInterval(new Interval(0.0, l));
        }
        long l2 = 1000L;
        if (l > (long)0) {
            l2 = l / (long)this.widthGauge;
        }
    }

    public void processTimeEvent(TimeEvent timeEvent) {
        if (timeEvent.getActionCommand().equals("TICK")) {
            this.gauge.setValue(this.timeLine.getTime());
        } else if (timeEvent.getActionCommand().equals("DONE")) {
            this.startStopButton.setLabel("START");
            this.startStopButton.repaint();
        } else {
            super.processTimeEvent(timeEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.startStopButton) {
            if (this.startStopButton.getLabel().equals("STOP")) {
                if (this.timeLine != null) {
                    this.timeLine.reset();
                }
                SoundPlayer.stop();
                if (this.applet != null) {
                    this.applet.flushApplet();
                    this.applet.repaintApplet();
                }
                this.startStopButton.setLabel("START");
            } else {
                this.startStopButton.setLabel("STOP");
                if (this.timeLine != null) {
                    this.timeLine.reset();
                }
                if (this.applet != null) {
                    if (this.applet.isRewindable()) {
                        this.rewindApplet();
                        this.applet.repaintApplet();
                    } else {
                        this.setApplet();
                        this.setEventSequence(this.timeLineString);
                    }
                }
            }
        }
    }

    protected void addApplet() {
        if (this.applet != null) {
            this.setLayout(new AbsoluteLayout());
            this.add((Component)this.applet, new Rectangle(0, 0, 600, 321));
            this.add((Component)this.toolBar, new Rectangle(0, 321, 600, 29));
        }
    }
}

