/*
 * Decompiled with CFR 0.152.
 */
package phy.applet.quantacd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import phy.control.TabsPanel;
import phy.function.SineFunction;
import phy.graphe.BufferedPanel;
import phy.graphe.DrawableEquation;
import phy.quanta.BoiteStateChooser;
import phy.quanta.BoiteViewer;
import phy.quanta.BufferedPanelBis;
import phy.quanta.QuantaApplet;
import phy.util.AbsoluteLayout;
import phy.util.CrackedString;
import phy.util.PhysicApplet;

public class Boite
extends QuantaApplet {
    protected BufferedPanel equationViewer;
    protected TabsPanel tabsPanel;
    protected BoiteStateChooser chooser;
    protected BoiteViewer viewer;

    public void init() {
        super.init();
        this.chooser = new BoiteStateChooser();
        this.chooser.setBackground(Color.lightGray);
        this.chooser.setForeground(Color.black);
        this.chooser.setMinIndex(1);
        this.viewer = new BoiteViewer(new SineFunction(), new SineFunction());
        this.viewer.setRange(-1.0, 1.0);
        BufferedPanel bufferedPanel = new BufferedPanel();
        bufferedPanel.setLayout(new AbsoluteLayout());
        bufferedPanel.setBackground(Color.lightGray);
        bufferedPanel.add((Component)this.viewer, new Rectangle(5, 5, 270, 270));
        this.chooser.addActionListener(this.viewer);
        this.equationViewer = new BufferedPanelBis();
        this.equationViewer.setBackground(Color.lightGray);
        this.equationViewer.addDrawableObject("EQ1", new DrawableEquation("\\hat{H} = \\frac{p_x^2}{2m}+\\frac{p_y^2}{2m}+V(x,y)", new Point(30, 10), 4, Color.black));
        this.equationViewer.addDrawableObject("EQ2", new DrawableEquation("V(x,y) = U(x) + U(y)", new Point(30, 65), 4, Color.black));
        this.equationViewer.addDrawableObject("EQ3", new DrawableEquation("\\psi_{n_1,n_2}(x,y) = \\psi_{n_1}(x) \\psi_{n_2}(y)", new Point(30, 100), 4, Color.blue));
        this.equationViewer.addDrawableObject("EQ4", new DrawableEquation("E_{n_1,n_2}=E_{n_1}+E_{n_2}", new Point(30, 130), 4, Color.blue));
        this.tabsPanel = new TabsPanel();
        this.tabsPanel.setTabCornerRadius(20);
        this.tabsPanel.addPage("EQ", " Equations ", this.equationViewer);
        this.tabsPanel.addPage("SELECTOR", PhysicApplet.getWord("Selection"), this.chooser);
        this.setLayout(new AbsoluteLayout());
        this.add((Component)bufferedPanel, new Rectangle(10, 20, 280, 280));
        this.add((Component)this.tabsPanel, new Rectangle(320, 20, 260, 280));
        this.initApplet();
        this.setDefaultListener(this.equationViewer);
        this.setRewindable(false);
    }

    public void initApplet() {
        this.equationViewer.clearFlags();
        this.tabsPanel.getPanelControl().setEnabled(false);
        this.viewer.setHidden(true);
        this.viewer.setMouseActive(false);
        this.chooser.setMouseActive(false);
    }

    public void flushApplet() {
        this.equationViewer.setFlags("EQ1,EQ2,EQ3,EQ4");
        this.actionPerformed("SHOW IMAGE");
        this.actionPerformed("LISTENER SELECTOR");
        this.actionPerformed("REMOTE_MOUSE OFF");
        this.actionPerformed("MOUSE ON");
        this.actionPerformed("LISTENER VIEWER");
        this.actionPerformed("REMOTE_MOUSE OFF");
        this.actionPerformed("MOUSE ON");
        this.actionPerformed("TABS ENABLE");
        this.actionPerformed("TAB SELECTOR");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CrackedString crackedString = new CrackedString(actionEvent.getActionCommand());
        if (crackedString.getField(0).equals("TAB")) {
            this.tabsPanel.setPage(crackedString.getField(1));
        } else if (actionEvent.getActionCommand().equals("TABS ENABLE")) {
            this.tabsPanel.getPanelControl().setEnabled(true);
        } else if (crackedString.getField(0).equals("LISTENER")) {
            if (crackedString.getField(1).equals("EQ")) {
                this.setDefaultListener(this.equationViewer);
            } else if (crackedString.getField(1).equals("SELECTOR")) {
                this.setDefaultListener(this.chooser);
            } else if (crackedString.getField(1).equals("VIEWER")) {
                this.setDefaultListener(this.viewer);
            }
        } else if (actionEvent.getActionCommand().equals("SHOW IMAGE")) {
            this.viewer.setHidden(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

