/*
 * Decompiled with CFR 0.152.
 */
package phy.applet.quantacd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import phy.control.TabsPanel;
import phy.graphe.BufferedPanel;
import phy.graphe.DrawableEquation;
import phy.graphe.DrawableObject;
import phy.quanta.HermiteDecomposition;
import phy.util.AbsoluteLayout;
import phy.util.CrackedString;
import phy.util.PhysicApplet;

public class HermiteDecomposition2
extends HermiteDecomposition {
    protected BufferedPanel equationViewer;
    protected TabsPanel tabsPanel;

    public HermiteDecomposition2() {
        this.setMode("fit");
    }

    public void init() {
        super.init();
        this.tuner.setNPoints(5);
        this.getChoiceBasisSize().select("5");
        this.functionWindow.computeHermiteSum(this.tuner, this.hermitePolynomials);
        Panel panel = new Panel();
        panel.setCursor(Cursor.getPredefinedCursor(12));
        this.equationViewer = new BufferedPanel();
        this.equationViewer.setBackground(Color.lightGray);
        if (PhysicApplet.getLanguage().equals("FR")) {
            this.equationViewer.addDrawableObject("EQ1", (DrawableObject)new DrawableEquation("\\{|\\Phi_n>\\} \\mbox{ : Base hilbertienne}", new Point(140, 30), 3), Color.blue);
        } else {
            this.equationViewer.addDrawableObject("EQ1", (DrawableObject)new DrawableEquation("\\{|\\Phi_n>\\} \\mbox{ : Hilbert basis}", new Point(140, 30), 3), Color.blue);
        }
        this.equationViewer.addDrawableObject("EQ2", (DrawableObject)new DrawableEquation("f(x) = \\Sigma C_n \\Phi_n(x)", new Point(30, 80), 4), Color.black);
        this.equationViewer.addDrawableObject("EQ3", (DrawableObject)new DrawableEquation("C_n = \\int{\\Phi_n(x) f(x) dx}", new Point(30, 110), 4), Color.black);
        this.equationViewer.clearFlags("EQ1,EQ2,EQ3");
        this.getFunctionWindow().setForeground(Color.black);
        this.getFunctionWindow().setBackground(Color.lightGray);
        this.getFunctionWindow().setColor1(null);
        this.getFunctionWindow().setColor2(Color.red);
        this.tabsPanel = new TabsPanel();
        this.tabsPanel.setTabCornerRadius(20);
        this.tabsPanel.addPage("EQ", " Equations ", this.equationViewer);
        this.tabsPanel.addPage("Function", PhysicApplet.getWord("Graph"), this.getFunctionWindow());
        this.setLayout(new AbsoluteLayout());
        this.add((Component)this.tuner, new Rectangle(10, 10, 280, 275));
        this.add((Component)this.tabsPanel, new Rectangle(310, 10, 280, 275));
        this.add((Component)this.toolBar, new Rectangle(0, 289, 620, 31));
        this.setDefaultListener(this.tuner);
        this.tuner.setMouseActive(false);
        this.getFunctionWindow().setMouseActive(false);
        this.tuner.setVisible(false);
        this.disableToolBar();
        this.tabsPanel.getPanelControl().setEnabled(false);
        this.setRewindable(false);
        this.useToolBarHandCursor();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().startsWith("TAB ")) {
            this.tabsPanel.setPage(CrackedString.getField(actionEvent.getActionCommand(), 1));
        } else if (actionEvent.getActionCommand().equals("TABS ENABLE")) {
            this.tabsPanel.getPanelControl().setEnabled(true);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void flushApplet() {
        this.tuner.setMouseActive(true);
        this.tuner.remoteMouseOff();
        this.tuner.setVisible(true);
        this.enableToolBar();
        this.tabsPanel.getPanelControl().setEnabled(true);
        this.equationViewer.setFlags("EQ1,EQ2,EQ3");
        this.equationViewer.repaint();
        this.getFunctionWindow().remoteMouseOff();
        this.getFunctionWindow().setMouseActive(true);
        this.actionPerformed(new ActionEvent(this, 1001, "SHOW_BASIS OFF"));
        this.actionPerformed(new ActionEvent(this, 1001, "SHOW_FIT ON"));
        this.validate();
    }
}

