/*
 * Decompiled with CFR 0.152.
 */
package phy.applet.quantacd;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import phy.function.HyperGaussian;
import phy.graphe.DoubleArrow;
import phy.graphe.DrawableEquation;
import phy.graphe.DrawableObject;
import phy.graphe.UserLineSegment;
import phy.quanta.MultiPuits;
import phy.util.CrackedString;
import phy.util.DoublePoint;
import phy.util.PhysicApplet;

public class Quantization7
extends MultiPuits {
    protected UserLineSegment arrowSegment = new UserLineSegment(new DoublePoint(0.0, 0.0), new DoublePoint(0.0, 4.0));
    protected DrawableEquation searchEquation;

    public void init() {
        super.init();
        this.getMultiPuitsWindow().getPuits().setPotential(new HyperGaussian(2, 0.39, -4.0, 4.0));
        this.getMultiPuitsWindow().getPuits().initPotential();
        this.getMultiPuitsWindow().setShowEnergyLevels(false);
        this.getMultiPuitsWindow().setShowWaveFunctions(true);
        this.getMultiPuitsWindow().setShowSelect(true);
        this.getMultiPuitsWindow().setShowTrialFunction(true);
        DoubleArrow doubleArrow = new DoubleArrow(this.arrowSegment);
        doubleArrow.setArrowType(2);
        doubleArrow.setSize(16);
        this.getMultiPuitsWindow().addDrawableObject("DELTA_E", (DrawableObject)doubleArrow, Color.lightGray);
        this.searchEquation = new DrawableEquation("", new Point(10, 10), 4);
        this.getMultiPuitsWindow().addDrawableObject("EQ11", (DrawableObject)this.searchEquation, Color.yellow);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().startsWith("EMIN ")) {
            this.arrowSegment.a.y = CrackedString.getDouble(actionEvent.getActionCommand(), 1);
            this.getMultiPuitsWindow().repaint();
        } else if (actionEvent.getActionCommand().startsWith("EMAX ")) {
            this.arrowSegment.b.y = CrackedString.getDouble(actionEvent.getActionCommand(), 1);
            this.getMultiPuitsWindow().repaint();
        } else if (actionEvent.getActionCommand().startsWith("DICHOMIN ")) {
            this.arrowSegment.a.y = CrackedString.getDouble(actionEvent.getActionCommand(), 1);
            this.getMultiPuitsWindow().setEnergy((this.arrowSegment.a.y + this.arrowSegment.b.y) / (double)2);
            this.getMultiPuitsWindow().doComputation();
            this.getMultiPuitsWindow().repaint();
        } else if (actionEvent.getActionCommand().startsWith("DICHOMAX ")) {
            this.arrowSegment.b.y = CrackedString.getDouble(actionEvent.getActionCommand(), 1);
            this.getMultiPuitsWindow().setEnergy((this.arrowSegment.a.y + this.arrowSegment.b.y) / (double)2);
            this.getMultiPuitsWindow().doComputation();
            this.getMultiPuitsWindow().repaint();
        } else if (actionEvent.getActionCommand().startsWith("SEARCH ")) {
            if (PhysicApplet.getLanguage().equals("FR")) {
                this.searchEquation.setTeX(String.valueOf(String.valueOf("\\mbox{Recherche de l'\u00e9tat n = ").concat(String.valueOf(CrackedString.getInt(actionEvent.getActionCommand(), 1)))).concat(String.valueOf("}")));
            } else {
                this.searchEquation.setTeX(String.valueOf(String.valueOf("\\mbox{Seaching for state n = ").concat(String.valueOf(CrackedString.getInt(actionEvent.getActionCommand(), 1)))).concat(String.valueOf("}")));
            }
            this.getMultiPuitsWindow().repaint();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void initApplet() {
        super.initApplet();
        this.arrowSegment.a.y = 0.0;
        this.arrowSegment.b.y = 4.0;
        this.getMultiPuitsWindow().clearFlags("TRIAL_ENERGY,WAVE,DELTA_E,EQ11");
        this.getMultiPuitsWindow().clearFlags("LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4");
        this.getMultiPuitsWindow().setEnergy(2.0);
        this.getMultiPuitsWindow().doComputation();
    }

    public void flushApplet() {
        this.getMultiPuitsWindow().setMouseActive(true);
        this.getMultiPuitsWindow().setFlags("TRIAL_ENERGY,WAVE");
        this.getMultiPuitsWindow().setFlags("LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4");
        this.getMultiPuitsWindow().clearFlags("DELTA_E,EQ11");
    }
}

