/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.Dimension;
import java.awt.Point;
import phy.acq.DataObservable;
import phy.acq.DataObserver;
import phy.acq.PhyBean;
import phy.graphe.BufferedPanel;
import phy.util.MathTools;
import phy.util.TeXDimension;

public class DoubleValueDisplay
extends BufferedPanel
implements DataObserver {
    protected PhyBean bean;
    protected String property;
    protected String prefix = "";
    protected String suffix = "";
    protected int digits = -1;
    protected int scale = -1;

    public void setBean(PhyBean phyBean) {
        this.bean = phyBean;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public DoubleValueDisplay() {
    }

    public DoubleValueDisplay(DataObservable dataObservable, String string, String string2) {
        this();
        this.setBean(dataObservable);
        this.setProperty(string);
        int n = string2.indexOf("%");
        if (n < 0) {
            this.prefix = string2;
        } else {
            this.prefix = string2.substring(0, n);
            int n2 = string2.substring(n).indexOf("f");
            if (n2 >= 0) {
                this.suffix = string2.substring(n + n2 + 1);
                String string3 = string2.substring(n + 1, n + n2);
                if ((n2 = string3.indexOf(".")) >= 0) {
                    this.scale = Integer.valueOf(string3.substring(n2 + 1));
                    if (n2 > 0) {
                        this.digits = Integer.valueOf(string3.substring(0, n2));
                    }
                }
            }
        }
        dataObservable.addObserver(this);
    }

    protected String formatte(double d) {
        String string = String.valueOf("").concat(String.valueOf(d));
        if (this.digits > 0) {
            string = MathTools.formatte(d, this.scale, this.digits);
        } else if (this.scale >= 0) {
            string = MathTools.formatte(d, this.scale);
        }
        return string;
    }

    public void paintCore() {
        this.graphics.setColor(this.getForeground());
        Point point = new Point(5, this.getHeight() / 2);
        TeXDimension teXDimension = this.graphics.drawTeX(this.prefix, point, 6);
        point.x += teXDimension.width;
        double d = (Double)this.bean.getProperty(this.property);
        teXDimension = this.graphics.drawTeX(String.valueOf(String.valueOf("\\mbox{").concat(String.valueOf(this.formatte(d)))).concat(String.valueOf("}")), point, 6);
        point.x += teXDimension.width;
        this.graphics.drawTeX(this.suffix, point, 6);
    }

    public Dimension getPreferredSize() {
        this.setSize(10, 10);
        this.checkSizeIsCorrect();
        TeXDimension teXDimension = this.graphics.drawTeX(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.prefix).concat(String.valueOf("\\mbox{"))).concat(String.valueOf(this.formatte(0.0)))).concat(String.valueOf("}"))).concat(String.valueOf(this.suffix)), new Point(0, 0), false);
        teXDimension.width += 20;
        return teXDimension;
    }
}

