/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import phy.control.HotSpot;
import phy.util.MathTools;

public class HotPoint
extends HotSpot {
    public static final int XY = 0;
    public static final int X = 1;
    public static final int Y = 2;
    public static final int FIXED = 3;
    protected int x;
    protected int y;
    protected int type;

    public int distanceTo(int n, int n2) {
        return (int)Math.sqrt(MathTools.sqr(this.x - n) + MathTools.sqr(this.y - n2));
    }

    public HotPoint(int n, int n2) {
        this(n, n2, 0);
    }

    public HotPoint(Point point) {
        this(point.x, point.y, 0);
    }

    public HotPoint(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.type = n3;
    }

    public HotPoint(Point point, int n) {
        this(point.x, point.y, n);
    }

    public void paint(Graphics graphics, boolean bl) {
        if (this.isHidden()) {
            return;
        }
        if (bl) {
            graphics.setColor(Color.yellow);
            graphics.fillOval(this.x - 5, this.y - 5, 10, 10);
        } else {
            graphics.setColor(Color.red);
            graphics.fillOval(this.x - 5, this.y - 5, 10, 10);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setXY(int n, int n2) {
        if (this.type == 0 || this.type == 1) {
            this.x = n;
        }
        if (this.type == 0 || this.type == 2) {
            this.y = n2;
        }
    }

    public boolean isSelectable() {
        return this.type != 3;
    }
}

