/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import phy.acq.PhyBean;
import phy.control.ListValueMonitor;
import phy.util.EnumDoubleType;
import phy.util.EnumType;
import phy.util.PhyTools;
import phy.util.Unit;

public class ListDoubleValueMonitor
extends ListValueMonitor {
    protected double smallestStep = 0.0;

    public ListDoubleValueMonitor(PhyBean phyBean, String string, EnumType enumType) {
        super(phyBean, string, enumType);
    }

    public void updateDisplay() {
        if (this.bean != null && this.property != null && this.enumType != null) {
            int n;
            if (this.smallestStep == 0.0) {
                this.smallestStep = Double.MAX_VALUE;
                for (int i = 0; i < this.enumType.getMaxValue() - 1; ++i) {
                    this.smallestStep = Math.min(Math.abs(this.getDoubleValue(i + 1) - this.getDoubleValue(i)), this.smallestStep);
                }
            }
            this.bean.getProperty(this.property);
            double d = (Double)this.bean.getProperty(this.property);
            for (n = 0; n < this.enumType.getMaxValue() && !(Math.abs(d - this.getDoubleValue(n)) < this.smallestStep / (double)100); ++n) {
            }
            if (n < this.enumType.getMaxValue()) {
                this.choice.select(n);
            } else {
                PhyTools.issueMessage(String.valueOf("Valeur inconnue dans ListDoubleValue ").concat(String.valueOf(d)));
            }
        }
    }

    public void selectInternal(int n) {
        Object object = this.bean.getProperty(this.property);
        this.bean.setProperty(this.property, new Double(this.getDoubleValue(n)));
        this.propertyChangeSupport.firePropertyChange(this.property, object, this.bean.getProperty(this.property));
    }

    protected double getDoubleValue(int n) {
        if (this.enumType instanceof EnumDoubleType) {
            return ((EnumDoubleType)this.enumType).getDouble(n);
        }
        return Unit.getSIValue(this.enumType.getElement(n));
    }
}

