/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import phy.acq.PhyBean;
import phy.util.EnumType;

public class ListValueMonitor
extends Panel
implements ItemListener {
    protected Choice choice = new Choice();
    protected String label;
    protected PhyBean bean;
    protected String property;
    protected EnumType enumType;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void setBean(PhyBean phyBean) {
        this.bean = phyBean;
        this.updateDisplay();
    }

    public void setProperty(String string) {
        this.property = string;
        this.updateDisplay();
    }

    public void setEnumType(EnumType enumType) {
        this.enumType = enumType;
        this.choice.removeAll();
        for (int i = 0; i < this.enumType.getMaxValue(); ++i) {
            this.choice.add(this.enumType.getElement(i));
        }
        this.updateDisplay();
    }

    public int getSelectedIndex() {
        return this.choice.getSelectedIndex();
    }

    public ListValueMonitor() {
        this.setLayout(new GridLayout(1, 1));
        this.add(this.choice);
        this.choice.addItemListener(this);
    }

    public ListValueMonitor(PhyBean phyBean, String string, EnumType enumType) {
        this();
        this.setBean(phyBean);
        this.setProperty(string);
        this.setEnumType(enumType);
        this.updateDisplay();
    }

    public void updateDisplay() {
        if (this.bean != null && this.property != null && this.enumType != null) {
            Object object = this.bean.getProperty(this.property);
            this.choice.select((Integer)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.select(this.choice.getSelectedIndex());
    }

    public void select(int n) {
        this.choice.select(n);
        this.selectInternal(n);
    }

    public void selectInternal(int n) {
        Object object = this.bean.getProperty(this.property);
        this.bean.setProperty(this.property, new Integer(n));
        this.propertyChangeSupport.firePropertyChange(this.property, object, this.bean.getProperty(this.property));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setListEnabled(boolean bl) {
        if (bl) {
            this.choice.setForeground(Color.black);
        } else {
            this.choice.setForeground(Color.gray);
        }
        this.choice.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.choice.setFont(font);
    }
}

