/*
 * Decompiled with CFR 0.152.
 */
package phy.control;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import phy.control.HotAreaPolygon;

public class TabControl
extends HotAreaPolygon {
    protected int style = 0;
    public static final int SQUARE = 0;
    public static final int TRAPEZOID = 1;
    protected int side = 0;
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    protected Color foregroundColor = Color.black;
    protected String text;
    protected String name;
    protected double slope = 0.0;
    protected Rectangle border;

    public void setStyle(int n) {
        this.style = n;
    }

    public int getStyle() {
        return this.style;
    }

    public void setSide(int n) {
        this.side = n;
    }

    public int getSide() {
        return this.side;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public TabControl(String string) {
        this(string, string);
    }

    public TabControl(String string, String string2) {
        this.name = string;
        this.text = string2;
    }

    public void setBorder(int n, int n2, int n3, int n4) {
        this.border = new Rectangle(n, n2, n3, n4);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        if (this.getSide() == 0) {
            nArray[0] = n;
            nArray2[0] = n2;
            nArray[1] = n + n3;
            nArray2[1] = n2;
            nArray[2] = n + n3 - (int)(this.slope * (double)n4);
            nArray2[2] = n2 + n4;
            nArray[3] = n + (int)(this.slope * (double)n4);
            nArray2[3] = n2 + n4;
        } else if (this.getSide() == 1) {
            nArray[0] = n;
            nArray2[0] = n2 + n4;
            nArray[1] = n + n3;
            nArray2[1] = n2 + n4;
            nArray[2] = n + n3 - (int)(this.slope * (double)n4);
            nArray2[2] = n2;
            nArray[3] = n + (int)(this.slope * (double)n4);
            nArray2[3] = n2;
        }
        this.setPolygon(new Polygon(nArray, nArray2, 4));
    }

    public Rectangle getBorder() {
        return this.border;
    }

    public void paint(Graphics graphics, boolean bl, boolean bl2) {
        Polygon polygon = new Polygon(new int[]{this.border.x - 3, this.border.x + 3, this.border.x + this.border.width - 3, this.border.x + this.border.width + 3}, new int[]{this.border.y + this.border.height, this.border.y, this.border.y, this.border.y + this.border.height}, 4);
        if (bl) {
            graphics.setColor(Color.lightGray);
            if (this.getStyle() == 0) {
                graphics.fill3DRect(Math.max(0, this.border.x - 1), this.border.y, this.border.width + 1 + (this.border.x - Math.max(0, this.border.x - 1)), this.border.height, true);
            } else if (this.getStyle() == 1) {
                graphics.setColor(Color.lightGray);
                graphics.fillPolygon(polygon);
                graphics.setColor(Color.lightGray.brighter());
                graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0] - 1, polygon.xpoints[1], polygon.ypoints[1]);
                graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
                graphics.setColor(Color.black);
                graphics.drawLine(polygon.xpoints[2], polygon.ypoints[2], polygon.xpoints[3], polygon.ypoints[3] - 1);
            }
            graphics.setColor(Color.black);
            graphics.setFont(new Font(graphics.getFont().getName(), 1, graphics.getFont().getSize()));
        } else {
            graphics.setColor(Color.lightGray);
            if (this.getStyle() == 0) {
                graphics.fill3DRect(this.border.x, this.border.y, this.border.width, this.border.height - 3, true);
            } else {
                graphics.setColor(Color.lightGray);
                graphics.fillPolygon(polygon);
                graphics.setColor(Color.lightGray.brighter());
                graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0] - 1, polygon.xpoints[1], polygon.ypoints[1]);
                graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
                graphics.setColor(Color.black);
                graphics.drawLine(polygon.xpoints[2], polygon.ypoints[2], polygon.xpoints[3], polygon.ypoints[3] - 1);
            }
            if (bl2) {
                graphics.setColor(Color.red);
                graphics.setFont(new Font(graphics.getFont().getName(), 1, graphics.getFont().getSize()));
            } else {
                graphics.setColor(Color.black);
                graphics.setFont(new Font(graphics.getFont().getName(), 0, graphics.getFont().getSize()));
            }
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight() - 4;
        if (bl) {
            n += 2;
        }
        if (this.getStyle() == 1) {
            n += 4;
        }
        graphics.drawString(this.text, this.getPolygon().getBounds().x + this.getPolygon().getBounds().width / 2 - fontMetrics.stringWidth(this.text) / 2, n);
    }
}

