/*
 * Decompiled with CFR 0.152.
 */
package phy.function;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.function.CenteredFunction;
import phy.function.Function;
import phy.graphe.Scaler;

public class TabulatedFunctionV1
implements ActionListener {
    String myName = "No Name";
    Scaler scalerX;
    Scaler scalerY;
    int[] dataX;
    public int[] dataY;
    public double[] data;
    int step = 1;
    protected int nPoints = 100;
    int x0 = 0;
    double xCenterWindow = 0.0;
    int mode = 2;
    boolean tabulatedY = false;
    protected boolean validX = false;
    protected boolean validY = false;
    public static final int NPOINTS_RELATIVE = 0;
    public static final int NPOINTS_FIXE = 1;
    public static final int NPOINTS_ALL = 2;
    float fractionTabulated = 0.3f;
    Function function;

    public void setMyName(String string) {
        this.myName = string;
    }

    public String getMyName() {
        return this.myName;
    }

    public void setValidData(boolean bl) {
        this.validY = bl;
    }

    public TabulatedFunctionV1() {
        this(null);
    }

    public TabulatedFunctionV1(Function function) {
        this(function, new Scaler(), new Scaler());
    }

    public TabulatedFunctionV1(Function function, Scaler scaler) {
        this(function, scaler, new Scaler());
    }

    public TabulatedFunctionV1(Function function, Scaler scaler, Scaler scaler2) {
        this.function = function;
        this.scalerX = scaler;
        this.scalerY = scaler2;
        scaler.addActionListener(this);
        scaler2.addActionListener(this);
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public int getX0() {
        return this.x0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.scalerX) {
            if (actionEvent.getActionCommand().equals("NEW_NPIXELS")) {
                this.initializeArrays();
                this.validX = false;
                this.validY = false;
            } else if (actionEvent.getActionCommand().equals("NEW_BOUNDS")) {
                this.validX = false;
                this.validY = false;
            }
        } else if (actionEvent.getSource() == this.scalerY && (actionEvent.getActionCommand().equals("NEW_BOUNDS") || actionEvent.getActionCommand().equals("NEW_NPIXELS")) && this.tabulatedY) {
            this.validY = false;
        }
    }

    public double getValue(int n) {
        this.update();
        return this.data[n];
    }

    public int getXPixel(int n) {
        this.updateX();
        return this.dataX[n];
    }

    void initializeArrays() {
        switch (this.mode) {
            case 0: {
                this.nPoints = (int)(this.fractionTabulated * (float)this.scalerX.getNPixels());
                this.data = new double[this.nPoints];
                this.dataX = new int[this.nPoints];
                break;
            }
            case 2: {
                this.nPoints = this.scalerX.getNPixels();
                this.data = new double[this.nPoints];
                this.dataX = new int[this.nPoints];
                break;
            }
            case 1: {
                this.data = new double[this.nPoints];
                this.dataX = new int[this.nPoints];
            }
        }
        if (this.dataY != null) {
            this.dataY = new int[this.nPoints];
        }
    }

    void updateX0() {
        if (this.mode == 0 && this.function instanceof CenteredFunction) {
            int n = this.scalerX.getI(((CenteredFunction)this.function).getCenter()) - this.nPoints / 2;
            n = Math.max(0, Math.min(this.scalerX.getNPixels() - this.nPoints, n));
            if (n != this.x0) {
                this.x0 = n;
                this.validX = false;
            }
        }
    }

    void updateX() {
        if (this.dataX == null) {
            this.initializeArrays();
        }
        this.updateX0();
        if (this.validX) {
            return;
        }
        switch (this.mode) {
            case 2: {
                for (int i = 0; i < this.nPoints; ++i) {
                    this.dataX[i] = i;
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.nPoints; ++i) {
                    this.dataX[i] = i + this.x0;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.nPoints; ++i) {
                    this.dataX[i] = i * (this.scalerX.getNPixels() - 1) / (this.nPoints - 1);
                }
                break;
            }
        }
        this.validX = true;
    }

    public void update() {
        if (this.validY) {
            return;
        }
        this.updateX();
        if (this.function != null) {
            int n;
            for (n = 0; n < this.nPoints; ++n) {
                this.data[n] = this.function.getValue(this.scalerX.getX(this.dataX[n]));
            }
            if (this.dataY != null) {
                for (n = 0; n < this.nPoints; ++n) {
                    this.dataY[n] = this.scalerY.getI(this.data[n]);
                }
            }
            this.validY = true;
        }
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public void setNPoints(int n) {
        this.nPoints = n;
        this.dataX = null;
    }

    public Scaler getXScaler() {
        return this.scalerX;
    }

    public Scaler getYScaler() {
        return this.scalerY;
    }

    public void setXBounds(double d, double d2) {
        this.getXScaler().setBounds(d, d2);
    }

    public void setYBounds(double d, double d2) {
        this.getYScaler().setBounds(d, d2);
    }

    public int[] getYArray() {
        if (this.dataY == null) {
            this.dataY = new int[this.nPoints];
            this.tabulatedY = true;
            this.validY = false;
        }
        this.update();
        return this.dataY;
    }

    public int[] getXArray() {
        this.updateX();
        return this.dataX;
    }

    public void refresh() {
        this.setValidData(false);
        this.update();
    }
}

