/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.util.Vector;
import phy.function.Curve;
import phy.function.CurveInterface;
import phy.function.Function;
import phy.graphe.BufferedPanel;
import phy.graphe.FunctionViewerParameter;
import phy.graphe.Ticker;
import phy.util.Fonts;
import phy.util.PhysicApplet;
import phy.util.Unit;

public class FunctionViewer
extends BufferedPanel {
    protected boolean hotCursor = false;
    protected boolean showHotCursor = false;
    protected boolean roundAxis = true;
    protected boolean y0Visible = false;
    protected boolean x0Visible = false;
    protected boolean autoscale = false;
    protected boolean includeZero = false;
    public double autoscaleMargin = 1.0;
    protected Vector paramVector = new Vector();
    protected boolean rotated = false;
    protected Color axisLineColor = Color.gray;
    protected Color axisColor = Color.white;
    protected String title;
    protected String xLabel = "";
    protected String yLabel = "";
    protected boolean xAxisInversed = false;
    protected Function xFunction;
    protected boolean showAxis = false;
    protected int tickSize = 4;
    protected boolean zoomable = false;
    protected Ticker xTicker = new Ticker();
    protected Ticker yTicker = new Ticker();
    private double xMinEver = 1.0E30;
    private double xMaxEver = -1.0E30;

    public void setHotCursor(boolean bl) {
        this.hotCursor = bl;
    }

    public boolean isHotCursor() {
        return this.hotCursor;
    }

    public void setShowHotCursor(boolean bl) {
        this.hotCursor = bl;
    }

    public boolean isShowHotCursor() {
        return this.hotCursor;
    }

    public void setRoundAxis(boolean bl) {
        this.roundAxis = bl;
    }

    public boolean isRoundAxis() {
        return this.roundAxis;
    }

    public void setY0Visible(boolean bl) {
        this.y0Visible = bl;
    }

    public boolean isY0Visible() {
        return this.y0Visible;
    }

    public void setX0Visible(boolean bl) {
        this.x0Visible = bl;
    }

    public boolean isX0Visible() {
        return this.x0Visible;
    }

    public void setAutoscale(boolean bl) {
        this.autoscale = bl;
    }

    public boolean isAutoscale() {
        return this.autoscale;
    }

    public void setIncludeZero(boolean bl) {
        this.includeZero = bl;
    }

    public boolean isIncludeZero() {
        return this.includeZero;
    }

    public void setAutoscaleMargin(double d) {
        this.autoscaleMargin = d;
    }

    public double getAutoscaleMargin() {
        return this.autoscaleMargin;
    }

    public FunctionViewerParameter getParam(int n) {
        return (FunctionViewerParameter)this.paramVector.elementAt(n);
    }

    public void build() {
        super.build();
        if (this.isAutoscale()) {
            this.autoscaleYAxis();
        }
    }

    protected int getNCurves() {
        return this.paramVector.size();
    }

    public void setRotated(boolean bl) {
        this.rotated = bl;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setXLabel(String string) {
        this.xLabel = string;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public void setXUnit(Unit unit) {
        this.xTicker.setUnit(unit);
    }

    public Unit getXUnit() {
        return this.xTicker.getUnit();
    }

    public String getFullXLabel() {
        String string = this.getXLabel();
        if (this.getXUnit() != null) {
            string = String.valueOf(string).concat(String.valueOf(String.valueOf(String.valueOf(" [").concat(String.valueOf(this.getXUnit().getFullName()))).concat(String.valueOf("]"))));
        }
        return string;
    }

    public void setYLabel(String string) {
        this.yLabel = string;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public void setYUnit(Unit unit) {
        this.yTicker.setUnit(unit);
    }

    public Unit getYUnit() {
        return this.yTicker.getUnit();
    }

    public String getFullYLabel() {
        String string = this.getYLabel();
        if (this.getYUnit() != null) {
            string = String.valueOf(string).concat(String.valueOf(String.valueOf(String.valueOf(" [").concat(String.valueOf(this.getYUnit().getFullName()))).concat(String.valueOf("]"))));
        }
        return string;
    }

    public void setXAxisInversed(boolean bl) {
        this.xAxisInversed = bl;
    }

    public boolean isXAxisInversed() {
        return this.xAxisInversed;
    }

    public void setXFunction(Function function) {
        this.xFunction = function;
    }

    public Function getXFunction() {
        return this.xFunction;
    }

    public void setShowAxis(boolean bl) {
        this.showAxis = bl;
    }

    public boolean isShowAxis() {
        return this.showAxis;
    }

    public void setTickSize(int n) {
        this.tickSize = n;
    }

    public int getTickSize() {
        return this.tickSize;
    }

    public void setZoomable(boolean bl) {
        this.zoomable = bl;
        if (this.isZoomable()) {
            this.setMouseActive(true);
        }
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public FunctionViewer() {
        this.graphics.setHMargin(40);
        this.graphics.setVMargin(38);
        this.setBackground(Color.black);
        this.setMouseActive(false);
    }

    public FunctionViewer(Function function) {
        this();
        this.addFunction(function);
    }

    public void addFunction(Function function, int n, Color color, int n2) {
        Curve curve = new Curve();
        curve.setNPoints(n2);
        curve.calibrate(this.graphics.getX1(), this.graphics.getX2());
        curve.setFunction(function);
        this.paramVector.addElement(new FunctionViewerParameter(curve, n, color));
    }

    public void addFunction(Function function, int n, Color color) {
        this.addFunction(function, n, color, 100);
    }

    public void addFunction(Function function, int n) {
        Color color = Color.white;
        switch (this.getNCurves()) {
            case 0: {
                color = Color.red;
                break;
            }
            case 1: {
                color = Color.blue;
                break;
            }
            case 2: {
                color = Color.green;
            }
        }
        this.addFunction(function, n, color);
    }

    public void addFunction(Function function) {
        this.addFunction(function, 0);
    }

    public void addCurve(CurveInterface curveInterface, int n, Color color) {
        this.paramVector.addElement(new FunctionViewerParameter(curveInterface, n, color));
    }

    public void addCurve(CurveInterface curveInterface, int n) {
        Color color = Color.white;
        switch (this.getNCurves()) {
            case 0: {
                color = Color.red;
                break;
            }
            case 1: {
                color = Color.blue;
                break;
            }
            case 2: {
                color = Color.green;
            }
        }
        this.addCurve(curveInterface, n, color);
    }

    public void addCurve(CurveInterface curveInterface) {
        this.addCurve(curveInterface, 0);
    }

    public CurveInterface getCurve(int n) {
        return this.getParam(n).getCurve();
    }

    public void autoscaleXAxis() {
        boolean bl = true;
        int n = 0;
        for (n = 0; n < this.getNCurves(); ++n) {
            if (this.getCurve(n) instanceof Curve && ((Curve)this.getCurve(n)).getFunction() != null) continue;
            bl = false;
            break;
        }
        if (!bl) {
            double d = this.getCurve(n).getX(0);
            double d2 = this.getCurve(n).getX(this.getCurve(n).getNPoints() - 1);
            ++n;
            while (n < this.getNCurves()) {
                if (!(this.getCurve(n) instanceof Curve) || ((Curve)this.getCurve(n)).getFunction() == null) {
                    d = Math.min(d, this.getCurve(n).getX(0));
                    d2 = Math.max(d2, this.getCurve(n).getX(this.getCurve(n).getNPoints() - 1));
                }
                ++n;
            }
            this.setXAxis(d, d2);
        } else if (this.graphics.getX1() < this.graphics.getX2()) {
            this.setXAxis(this.xMinEver, this.xMaxEver);
        } else {
            this.setXAxis(this.xMaxEver, this.xMinEver);
        }
    }

    public void autoscaleYAxis() {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i = 0; i < this.getNCurves(); ++i) {
            if (!this.getParam(i).isVisible()) continue;
            for (int j = 0; j < this.getParam(i).getCurve().getNPoints(); ++j) {
                if (!this.getParam(i).getCurve().isAvailable(j)) continue;
                d = Math.min(d, this.getParam(i).getCurve().getY(j));
                d2 = Math.max(d2, this.getParam(i).getCurve().getY(j));
            }
        }
        if (this.isIncludeZero()) {
            if (d > 0.0) {
                d = 0.0;
                d2 = d + this.getAutoscaleMargin() * (d2 - d);
            } else if (d2 < 0.0) {
                d2 = 0.0;
                d = d2 + this.getAutoscaleMargin() * (d - d2);
            } else {
                double d3 = (d2 - d) * (this.getAutoscaleMargin() - 1.0);
                d2 += d3;
                d -= d3;
            }
        } else {
            double d4 = (d2 - d) * (this.getAutoscaleMargin() - 1.0);
            d2 += d4;
            d -= d4;
        }
        this.setYAxis(d, d2);
        this.initHotSpots();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("AUTO_Y")) {
            this.autoscaleYAxis();
            this.repaint();
        } else if (actionEvent.getActionCommand().equals("AUTO_X")) {
            this.autoscaleXAxis();
            this.repaint();
        } else if (actionEvent.getActionCommand().equals("AUTO_XY")) {
            this.autoscaleXAxis();
            this.autoscaleYAxis();
            this.repaint();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected double getActualX(int n, int n2) {
        double d = this.getParam(n).getCurve().getX(n2);
        if (this.getXFunction() != null) {
            d = this.getXFunction().getValue(d);
        } else if (this.isXAxisInversed() && d != 0.0) {
            d = 1.0 / d;
        }
        return d;
    }

    public void paintCore() {
        this.paintAxis();
        this.graphics.setClipping(true);
        this.graphics.setFont(Fonts.Times12);
        block8: for (int i = 0; i < this.getNCurves(); ++i) {
            int n;
            if (!this.getParam(i).isVisible()) continue;
            this.graphics.setColor(this.getParam(i).getColor());
            int n2 = this.getParam(i).getCurve().getNPoints();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                double d = this.getActualX(i, n);
                if (this.getParam(i).getValidInterval() != null && !this.getParam(i).getValidInterval().contains(d)) continue;
                nArray[n3] = this.xScreen(d);
                nArray2[n3] = this.yScreen(this.getParam(i).getCurve().getY(n));
                ++n3;
            }
            Polygon polygon = this.rotated ? new Polygon(nArray2, nArray, n3) : new Polygon(nArray, nArray2, n3);
            switch (this.getParam(i).getMode()) {
                case 0: {
                    this.graphics.graphics_drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
                    continue block8;
                }
                case 4: {
                    for (n = 0; n < polygon.npoints; ++n) {
                        if (!this.getParam(i).getCurve().isAvailable(n)) continue;
                        this.graphics.drawDisk(new Point(polygon.xpoints[n], polygon.ypoints[n]), 3);
                    }
                    continue block8;
                }
                case 5: {
                    for (n = 0; n < polygon.npoints; ++n) {
                        if (!this.getParam(i).getCurve().isAvailable(n)) continue;
                        this.graphics.drawBigCross(new Point(polygon.xpoints[n], polygon.ypoints[n]), 1, 5);
                    }
                    continue block8;
                }
                case 3: {
                    this.paintCurveScope(i, polygon);
                    this.graphics.getGraphics().translate(0, 1);
                    this.paintCurveScope(i, polygon);
                    this.graphics.getGraphics().translate(0, -1);
                    continue block8;
                }
                case 1: {
                    this.graphics.graphics_fillPolygon(polygon);
                    continue block8;
                }
                case 2: {
                    this.graphics.getGraphics().setXORMode(Color.red);
                    this.graphics.getGraphics().fillPolygon(polygon);
                }
            }
        }
        if (this.isShowHotCursor()) {
            this.graphics.drawString(String.valueOf(String.valueOf(String.valueOf("x = ").concat(String.valueOf(this.getXMouse()))).concat(String.valueOf("; y = "))).concat(String.valueOf(this.getYMouse())), new Point(this.getXMouse(), this.getYMouse()), 2);
        }
        this.graphics.setClipping(false);
        if (this.isMouseDown() && this.isZoomable()) {
            this.graphics.setColor(Color.red);
            this.graphics.drawRect(this.getMousePressedPoint(), this.getMousePoint());
        }
    }

    public void refresh() {
        for (int i = 0; i < this.getNCurves(); ++i) {
            if (!this.getParam(i).isVisible()) continue;
            this.getCurve(i).refresh();
        }
        if (this.isAutoscale()) {
            this.autoscaleYAxis();
        }
        this.repaint();
    }

    public void setXAxis(double d, double d2) {
        if (d == d2) {
            return;
        }
        this.xMinEver = Math.min(this.xMinEver, Math.min(d, d2));
        this.xMaxEver = Math.max(this.xMaxEver, Math.max(d, d2));
        super.setXAxis(d, d2);
        this.xTicker.setX1(d);
        this.xTicker.setX2(d2);
        this.xTicker.update();
        if (this.isRoundAxis()) {
            super.setXAxis(this.xTicker.getOuterX1(), this.xTicker.getOuterX2());
            this.xTicker.setX1(this.xTicker.getOuterX1());
            this.xTicker.setX2(this.xTicker.getOuterX2());
            this.xTicker.update();
        }
        for (int i = 0; i < this.getNCurves(); ++i) {
            CurveInterface curveInterface = this.getCurve(i);
            if (curveInterface instanceof Curve && ((Curve)curveInterface).getFunction() != null) {
                ((Curve)curveInterface).calibrate(this.graphics.getX1(), this.graphics.getX2());
            }
            curveInterface.refresh();
        }
    }

    public void setYAxis(double d, double d2) {
        super.setYAxis(d, d2);
        this.yTicker.setX1(d);
        this.yTicker.setX2(d2);
        this.yTicker.update();
        if (this.isRoundAxis()) {
            super.setYAxis(this.yTicker.getOuterX1(), this.yTicker.getOuterX2());
            this.yTicker.setX1(this.yTicker.getOuterX1());
            this.yTicker.setX2(this.yTicker.getOuterX2());
            this.yTicker.update();
        }
    }

    protected void paintCurveScope(int n, Polygon polygon) {
        if (PhysicApplet.isFastDrawing()) {
            this.graphics.getGraphics().drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            return;
        }
        int n2 = this.getParam(n).getColor().getRed();
        int n3 = this.getParam(n).getColor().getBlue();
        int n4 = this.getParam(n).getColor().getGreen();
        for (int i = 0; i < polygon.npoints - 1; ++i) {
            float f = (float)(0.2 + (double)(3 * Math.abs(polygon.xpoints[i + 1] - polygon.xpoints[i])) / (0.1 + (double)Math.abs(polygon.ypoints[i + 1] - polygon.ypoints[i])));
            f = Math.min(f, 1.0f) / (float)256;
            this.graphics.setColor(new Color((float)n2 * f, (float)n4 * f, (float)n3 * f));
            this.graphics.getGraphics().drawLine(polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
        }
    }

    protected void paintAxis() {
        if (this.showAxis) {
            int n;
            int n2;
            this.graphics.setColor(this.axisLineColor);
            if (this.isX0Visible()) {
                this.graphics.drawLine(0.0, this.getY1(), 0.0, this.getY2());
            }
            if (this.isY0Visible()) {
                this.graphics.drawLine(this.getX1(), 0.0, this.getX2(), 0.0);
            }
            this.graphics.setColor(this.axisColor);
            this.graphics.setClipping(false);
            this.graphics.drawRect(this.graphics.getOriginVuport(), this.graphics.getDimensionVuport());
            int n3 = this.graphics.getXVuport();
            int n4 = this.graphics.getYVuport() + this.graphics.getHVuport();
            for (n2 = 0; n2 < this.xTicker.getNTicks(); ++n2) {
                if (!this.xTicker.isVisible(n2)) continue;
                n = this.xTicker.getI(n2);
                this.graphics.drawLine(new Point(n, n4), new Point(n, n4 - this.tickSize));
                this.graphics.drawString(this.xTicker.getTickLabel(n2), new Point(n, n4 + 3), 3);
            }
            this.graphics.drawString(this.getFullXLabel(), new Point(this.graphics.getXVuport() + this.graphics.getWVuport() / 2, this.getHeight() - 5), 0);
            for (n2 = 0; n2 < this.yTicker.getNTicks(); ++n2) {
                if (!this.yTicker.isVisible(n2)) continue;
                n = this.yTicker.getI(n2);
                this.graphics.drawLine(new Point(n3, n), new Point(n3 + this.tickSize, n));
                this.graphics.drawString(this.yTicker.getTickLabel(n2), new Point(n3 - 3, n), 8);
            }
            this.graphics.drawString(this.getFullYLabel(), new Point(this.graphics.getXVuport(), this.graphics.getYVuport() - 5), 1);
            if (this.getTitle() != null) {
                this.graphics.drawString(this.getTitle(), new Point(this.graphics.getXVuport() + this.graphics.getWVuport(), 5), 5);
            }
        }
    }

    public void sizeHasChanged() {
        this.xTicker.setScaler(this.graphics.getXScaler());
        this.xTicker.update();
        this.yTicker.setScaler(this.graphics.getYScaler());
        this.yTicker.update();
    }

    public void mousePressed() {
        super.mousePressed();
        if (this.isControlDown()) {
            this.autoscaleXAxis();
            this.autoscaleYAxis();
            this.repaint();
        }
    }

    public void mouseDragged() {
        super.mouseDragged();
        if (this.isZoomable() && !this.isControlDown()) {
            this.repaint();
        }
    }

    public void mouseReleased() {
        if (this.isZoomable() && !this.isControlDown()) {
            double d;
            double d2;
            double d3 = this.graphics.xUser(this.getXMousePressed());
            double d4 = this.graphics.xUser(this.getXMouse());
            double d5 = this.graphics.yUser(this.getYMousePressed());
            double d6 = this.graphics.yUser(this.getYMouse());
            double d7 = Math.min(d5, d6);
            double d8 = Math.max(d5, d6);
            if (this.graphics.getX1() < this.graphics.getX2()) {
                d2 = Math.min(d3, d4);
                d = Math.max(d3, d4);
                d2 = Math.max(d2, this.graphics.getX1());
                d = Math.min(d, this.graphics.getX2());
            } else {
                d2 = Math.max(d3, d4);
                d = Math.min(d3, d4);
                d2 = Math.min(d2, this.graphics.getX1());
                d = Math.max(d, this.graphics.getX2());
            }
            this.setXAxis(d2, d);
            this.setYAxis(d7, d8);
            this.repaint();
        }
        super.mouseReleased();
    }

    public void mouseMoved() {
        super.mouseMoved();
        if (this.isHotCursor()) {
            this.setShowHotCursor(true);
            this.repaint();
        }
    }
}

