/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.io.Serializable;
import phy.function.Function;
import phy.function.TabulatedFunctionV1;
import phy.graphe.BufferedPanel;
import phy.graphe.ViewerParameter;
import phy.util.PhysicApplet;

public class MultiFunctionViewer
extends BufferedPanel {
    int nCurves = 0;
    ViewerParameter[] param = new ViewerParameter[10];
    boolean rotated = false;
    String xLabel;
    String yLabel;
    protected boolean showAxis = false;

    public void setXLabel(String string) {
        this.xLabel = string;
    }

    public void setYLabel(String string) {
        this.yLabel = string;
    }

    public void setShowAxis(boolean bl) {
        this.showAxis = bl;
    }

    public boolean isShowAxis() {
        return this.showAxis;
    }

    public MultiFunctionViewer() {
        this.setBackground(Color.black);
    }

    public MultiFunctionViewer(Function function) {
        this();
        this.addCurve(new TabulatedFunctionV1(function));
    }

    public MultiFunctionViewer(TabulatedFunctionV1 tabulatedFunctionV1) {
        this();
        this.addCurve(tabulatedFunctionV1);
    }

    public void addCurve(TabulatedFunctionV1 tabulatedFunctionV1, int n, Color color) {
        if (this.nCurves < 10) {
            this.param[this.nCurves++] = new ViewerParameter(tabulatedFunctionV1, n, color);
        }
    }

    public void addCurve(TabulatedFunctionV1 tabulatedFunctionV1, int n) {
        Color color = Color.white;
        switch (this.nCurves) {
            case 0: {
                color = Color.red;
                break;
            }
            case 1: {
                color = Color.blue;
                break;
            }
            case 2: {
                color = Color.green;
            }
        }
        this.addCurve(tabulatedFunctionV1, n, color);
    }

    public TabulatedFunctionV1 getCurve(int n) {
        return this.param[n].getTabulatedFunction();
    }

    public void addCurve(TabulatedFunctionV1 tabulatedFunctionV1) {
        this.addCurve(tabulatedFunctionV1, 0);
    }

    public void sizeHasChanged() {
        if (this.rotated) {
            for (int i = 0; i < this.nCurves; ++i) {
                this.getCurve(i).getYScaler().setNPixels(this.getWidth());
                this.getCurve(i).getXScaler().setNPixels(this.getHeight());
            }
        } else {
            for (int i = 0; i < this.nCurves; ++i) {
                this.getCurve(i).getXScaler().setNPixels(this.getWidth());
                this.getCurve(i).getYScaler().setNPixels(this.getHeight());
            }
        }
    }

    protected void paintCurveScope(int n, Polygon polygon) {
        if (PhysicApplet.isFastDrawing()) {
            this.graphics.getGraphics().drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
            return;
        }
        int n2 = this.param[n].getColor().getRed();
        int n3 = this.param[n].getColor().getBlue();
        int n4 = this.param[n].getColor().getGreen();
        for (int i = 0; i < polygon.npoints - 1; ++i) {
            float f = (float)(0.2 + (double)(3 * Math.abs(polygon.xpoints[i + 1] - polygon.xpoints[i])) / (0.1 + (double)Math.abs(polygon.ypoints[i + 1] - polygon.ypoints[i])));
            f = Math.min(f, 1.0f) / (float)256;
            this.graphics.setColor(new Color((float)n2 * f, (float)n4 * f, (float)n3 * f));
            this.graphics.getGraphics().drawLine(polygon.xpoints[i], polygon.ypoints[i], polygon.xpoints[i + 1], polygon.ypoints[i + 1]);
        }
    }

    public void paintCore() {
        Serializable serializable;
        block6: for (int i = 0; i < this.nCurves; ++i) {
            this.graphics.setColor(this.param[i].getColor());
            serializable = this.rotated ? new Polygon(this.getCurve(i).getYArray(), this.getCurve(i).getXArray(), this.getCurve(i).getNPoints()) : new Polygon(this.getCurve(i).getXArray(), this.getCurve(i).getYArray(), this.getCurve(i).getNPoints());
            switch (this.param[i].getMode()) {
                case 0: {
                    this.graphics.getGraphics().drawPolyline(serializable.xpoints, serializable.ypoints, serializable.npoints);
                    continue block6;
                }
                case 3: {
                    this.paintCurveScope(i, (Polygon)serializable);
                    this.graphics.getGraphics().translate(0, 1);
                    this.paintCurveScope(i, (Polygon)serializable);
                    this.graphics.getGraphics().translate(0, -1);
                    continue block6;
                }
                case 1: {
                    this.graphics.getGraphics().fillPolygon((Polygon)serializable);
                    continue block6;
                }
                case 2: {
                    this.graphics.getGraphics().setXORMode(Color.red);
                    this.graphics.getGraphics().fillPolygon((Polygon)serializable);
                }
            }
        }
        if (this.showAxis) {
            this.graphics.setColor(Color.white);
            Point point = new Point(0, this.getCurve(0).getYScaler().getI(0.0));
            serializable = new Point(this.getWidth(), this.getCurve(0).getYScaler().getI(0.0));
            this.graphics.drawArrow(point, (Point)serializable);
            if (this.xLabel != null) {
                this.graphics.getGraphics().drawString(this.xLabel, ((Point)serializable).x - this.graphics.getStringWidth(this.xLabel) - 5, ((Point)serializable).y - 8);
            }
            int n = Math.max(0, this.getCurve(0).getXScaler().getI(0.0));
            point = new Point(n, this.getHeight());
            serializable = new Point(n, 0);
            this.graphics.drawArrow(point, (Point)serializable);
            if (this.yLabel != null) {
                this.graphics.getGraphics().drawString(this.yLabel, ((Point)serializable).x + 8, ((Point)serializable).y + this.graphics.getStringHeight());
            }
        }
    }

    public void setRotated(boolean bl) {
        this.rotated = bl;
    }

    public void refresh() {
        for (int i = 0; i < this.nCurves; ++i) {
            this.getCurve(i).setValidData(false);
            this.getCurve(i).update();
        }
        this.repaint();
    }
}

