/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.MemoryImageSource;
import phy.function.Factorized2DFunction;
import phy.graphe.BufferedPanel;
import phy.graphe.Scaler;
import phy.util.ColorScale;
import phy.util.MathTools;

public class QuantumViewer2D
extends BufferedPanel {
    MemoryImageSource imageSource;
    Image image;
    int[] data = null;
    Factorized2DFunction function;
    double minValue = -0.0625;
    double maxValue = 0.0625;
    protected boolean hidden = false;
    protected boolean boundDrawn = false;

    public void setRange(double d, double d2) {
        this.minValue = d;
        this.maxValue = d2;
    }

    public Scaler getXScaler() {
        return this.function.getXScaler();
    }

    public Scaler getYScaler() {
        return this.function.getYScaler();
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
        this.repaint();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setBoundDrawn(boolean bl) {
        this.boundDrawn = bl;
    }

    public boolean isBoundDrawn() {
        return this.boundDrawn;
    }

    public QuantumViewer2D(Factorized2DFunction factorized2DFunction) {
        this.function = factorized2DFunction;
        this.setBackground(Color.black);
        this.setMouseActive(true);
    }

    public Factorized2DFunction getFunction() {
        return this.function;
    }

    Image buildImage(int n, int n2) {
        this.data = new int[n * n2];
        this.imageSource = new MemoryImageSource(n, n2, this.data, 0, n);
        this.imageSource.setAnimated(true);
        return this.createImage(this.imageSource);
    }

    void initImage() {
        this.image = this.buildImage(this.function.getWidth(), this.function.getHeight());
    }

    public void sizeHasChanged() {
        this.function.getXScaler().setNPixels(this.getWidth());
        this.function.getYScaler().setNPixels(this.getHeight());
        this.initImage();
        this.setSizeBeingChanged(false);
        this.computeData();
        this.imageSource.newPixels();
    }

    synchronized void computeData() {
        if (this.isSizeBeingChanged()) {
            return;
        }
        for (int i = 0; i < this.function.getWidth(); ++i) {
            for (int j = 0; j < this.function.getHeight(); ++j) {
                this.data[i + j * this.function.getWidth()] = ColorScale.doubleToColorIndex((this.function.getValue(i, j) - this.minValue) / (this.maxValue - this.minValue) * (double)2 - 1.0);
            }
        }
    }

    public void paintCore() {
        if (this.isHidden()) {
            return;
        }
        if (this.image != null) {
            this.graphics.getGraphics().drawImage(this.image, this.function.getX0(), this.function.getY0(), this);
        }
        if (this.isMouseDown()) {
            this.graphics.setColor(Color.yellow);
            int n = Math.min(this.getWidth() / 10, this.getHeight() / 10);
            if (this.getXMouse() >= 0 && this.getXMouse() < this.getWidth() && this.getYMouse() >= 0 && this.getYMouse() < this.getHeight()) {
                this.graphics.getGraphics().drawLine(this.getXMouse(), 0, this.getXMouse(), this.getHeight());
                int[] nArray = new int[this.getHeight()];
                for (int i = 0; i < this.getHeight(); ++i) {
                    nArray[i] = this.getXMouse() + (int)Math.rint(this.function.getValue(this.getXMouse(), i) * (double)n);
                }
                this.graphics.getGraphics().drawPolyline(nArray, MathTools.getRamp(this.getHeight()), this.getHeight());
                this.graphics.getGraphics().drawLine(0, this.getYMouse(), this.getWidth(), this.getYMouse());
                int[] nArray2 = new int[this.getWidth()];
                for (int i = 0; i < this.getWidth(); ++i) {
                    nArray2[i] = this.getYMouse() - (int)Math.rint(this.function.getValue(i, this.getYMouse()) * (double)n);
                }
                this.graphics.getGraphics().drawPolyline(MathTools.getRamp(this.getWidth()), nArray2, this.getWidth());
            }
        }
        if (this.isBoundDrawn()) {
            this.graphics.setColor(Color.gray);
            this.graphics.drawRect(new Point(0, 0), new Dimension(this.getWidth() - 1, this.getHeight() - 1));
        }
    }

    public void refresh() {
        if (this.image == null) {
            return;
        }
        this.function.invalidateData();
        this.computeData();
        this.imageSource.newPixels();
    }

    public void mousePressed() {
        super.mousePressed();
        this.repaint();
    }

    public void mouseDragged() {
        super.mouseDragged();
        this.repaint();
    }
}

