/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import phy.util.ActionEventSupport;

public class Scaler
extends ActionEventSupport {
    protected int nPixels = 100;
    protected int margin1 = 0;
    protected int margin2 = 0;
    protected double alpha;
    protected double beta;
    protected double x1 = 0.0;
    protected double x2 = 1.0;
    protected double offset;

    public void setNPixels(int n) {
        this.nPixels = n;
        this.update();
        this.fireActionEvent("NEW_NPIXELS");
    }

    public int getNPixels() {
        return this.nPixels;
    }

    public int getNPixelsUsed() {
        return this.nPixels - this.margin1 - this.margin2;
    }

    public int getMargin1() {
        return this.margin1;
    }

    public void setMargin1(int n) {
        this.margin1 = n;
    }

    public int getMargin2() {
        return this.margin2;
    }

    public void setMargin2(int n) {
        this.margin2 = n;
    }

    public void setMargin(int n) {
        this.margin1 = this.margin2 = n;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double d) {
        this.beta = d;
    }

    public double getX1() {
        return this.x1;
    }

    public double getX2() {
        return this.x2;
    }

    public void setBounds(double d, double d2) {
        this.x1 = d;
        this.x2 = d2;
        this.update();
        this.fireActionEvent("NEW_BOUNDS");
    }

    public void setOffset(double d) {
        this.offset = d;
        this.update();
        this.fireActionEvent("NEW_BOUNDS");
    }

    public Scaler() {
        this.update();
    }

    public Scaler(int n, double d, double d2) {
        this.nPixels = n;
        this.setBounds(d, d2);
    }

    public Scaler(int n, double d, double d2, int n2, int n3) {
        this.nPixels = n;
        this.margin1 = n2;
        this.margin2 = n3;
        this.setBounds(d, d2);
    }

    public void translate(int n) {
        this.beta += (double)n;
    }

    public void update() {
        this.alpha = (double)(this.getNPixelsUsed() - 1) / (this.x2 - this.x1);
        this.beta = -this.alpha * this.x1 + (double)this.nPixels * this.offset;
    }

    public int getI(double d) {
        return (int)Math.max(-10000.0, Math.min(Math.rint(this.alpha * d + this.beta) + (double)this.margin1, 10000.0));
    }

    public int getDeltaI(double d) {
        return (int)Math.rint(this.alpha * d);
    }

    public double getX(int n) {
        return ((double)(n - this.margin1) - this.beta) / this.alpha;
    }
}

