/*
 * Decompiled with CFR 0.152.
 */
package phy.graphe;

import phy.graphe.Scaler;
import phy.util.MathTools;
import phy.util.Unit;

public class Ticker {
    public final int HORIZONTAL = 0;
    public final int VERTICAL = 1;
    protected int orientation = 0;
    protected Scaler scaler;
    protected double x1;
    protected double x2;
    protected double outerX1;
    protected double outerX2;
    protected int nTicks;
    protected int maxTicks = 8;
    protected int additionalDigits = 0;
    protected int charSize = 10;
    protected Unit unit;
    protected static double[] steps = new double[]{0.05, 0.1, 0.2, 0.25, 0.5, 1.0, 2.0, 2.5, 5.0, 10.0};

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void setScaler(Scaler scaler) {
        this.scaler = scaler;
    }

    public Scaler getScaler() {
        return this.scaler;
    }

    public double getX1() {
        return this.x1;
    }

    public void setX1(double d) {
        this.x1 = d;
    }

    public double getX2() {
        return this.x2;
    }

    public void setX2(double d) {
        this.x2 = d;
    }

    public double getOuterX1() {
        return this.outerX1;
    }

    public double getOuterX2() {
        return this.outerX2;
    }

    public int getNTicks() {
        return this.nTicks;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Ticker() {
    }

    public Ticker(Scaler scaler) {
        this();
        this.setScaler(scaler);
    }

    public double getX(int n) {
        return this.getOuterX1() + (this.getOuterX2() - this.getOuterX1()) * (double)n / ((double)this.nTicks - 1.0);
    }

    public boolean isVisible(int n) {
        double d = this.getX(n);
        double d2 = Math.abs(this.getX2() - this.getX1()) / (double)1000;
        return d > Math.min(this.getX1(), this.getX2()) - d2 && d < Math.max(this.getX1(), this.getX2()) + d2;
    }

    public int getI(int n) {
        return this.scaler.getI(this.getX(n));
    }

    public String getTickLabel(int n) {
        int n2;
        double d = this.getX(n);
        double d2 = Math.abs(this.getOuterX2() - this.getOuterX1()) / ((double)this.nTicks - 1.0);
        if (this.getUnit() != null) {
            d /= this.getUnit().getScale();
            d2 /= this.getUnit().getScale();
        }
        if ((n2 = -((int)Math.floor(MathTools.log10(d2))) + this.additionalDigits) < 0) {
            n2 = 0;
        }
        double d3 = Math.pow(10.0, n2);
        d = (double)Math.round(d * d3) / d3;
        return MathTools.formatte(d, n2);
    }

    public void update() {
        double d;
        double d2 = 1.0;
        if (this.getUnit() != null) {
            d2 = this.getUnit().getScale();
        }
        double d3 = (this.x2 - this.x1) / d2;
        int n = 11;
        double d4 = this.x1 / d2 + d3 / (double)1000;
        double d5 = this.x2 / d2 - d3 / (double)1000;
        double d6 = Math.pow(10.0, Math.log(Math.abs(d3)) / Math.log(10.0) - Math.floor((Math.log(Math.abs(d3)) - Math.log(1.2)) / Math.log(10.0)));
        int n2 = 0;
        double d7 = (double)10 * Math.abs(d5 - d4);
        for (int i = 0; i < 10; ++i) {
            d = steps[i] * d3 / d6;
            this.outerX1 = Math.floor(d4 / Math.abs(d)) * Math.abs(d);
            this.outerX2 = Math.floor(d5 / Math.abs(d)) * Math.abs(d);
            if (d3 > 0.0) {
                this.outerX2 += d;
            } else {
                this.outerX1 -= d;
            }
            n = (int)Math.abs((this.outerX2 - this.outerX1) / d + 0.2) + 1;
            if (n > this.maxTicks || !(Math.abs(this.outerX2 - this.outerX1) < d7)) continue;
            n2 = i;
            d7 = Math.abs(this.outerX2 - this.outerX1);
        }
        d = steps[n2] * d3 / d6;
        this.additionalDigits = n2 == 3 || n2 == 7 ? 1 : 0;
        this.outerX1 = Math.floor(d4 / Math.abs(d)) * Math.abs(d);
        this.outerX2 = Math.floor(d5 / Math.abs(d)) * Math.abs(d);
        if (d3 > 0.0) {
            this.outerX2 += d;
        } else {
            this.outerX1 -= d;
        }
        this.nTicks = (int)Math.abs((this.outerX2 - this.outerX1) / d + 0.2) + 1;
        this.outerX1 *= d2;
        this.outerX2 *= d2;
    }
}

