/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import phy.control.NavigationPanel;
import phy.control.PhyButton;
import phy.dynaplot.PlotDataSet;
import phy.quanta.DPLevelWindow;
import phy.quanta.MolecularViewer;
import phy.quanta.Molecule;
import phy.quanta.QuantaApplet;
import phy.util.PhysicApplet;

public class DoublePuits
extends QuantaApplet
implements ActionListener {
    String message = null;
    DPLevelWindow levelWindow;
    MolecularViewer molecularViewer;
    Molecule molecule;
    int sleepTime = 50;
    double step = 1.0;
    PlotDataSet dataSet;
    Button switchButton;
    PhyButton playButton;
    protected double lastTime = 0.0;

    public void init() {
        super.init();
        this.initSimulator();
        this.getSimulator().setTMax(Double.MAX_VALUE);
        this.getSimulator().getTimer().addActionListener(this);
        this.molecule = new Molecule();
        this.molecule.addVert("N", 0.0f, 0.0f, 0.0f);
        this.molecule.addVert("H", -1.0f, 1.0f, 1.0f);
        this.molecule.addVert("H", 1.0f, -1.0f, 1.0f);
        this.molecule.addVert("H", 1.0f, 1.0f, -1.0f);
        this.molecule.setCenteredCube(true);
        this.molecularViewer = new MolecularViewer(this.molecule);
        this.molecularViewer.yRot(20.0);
        this.molecularViewer.xRot(20.0);
        this.molecularViewer.setCursor(Cursor.getPredefinedCursor(12));
        this.setToolBar(new NavigationPanel());
        this.playButton = new PhyButton("PAUSE");
        this.getToolBar().add(this.playButton);
        this.playButton.addActionListener(this);
        this.switchButton = new Button(PhysicApplet.getWord("OtherVision"));
        this.getToolBar().add(this.switchButton);
        this.switchButton.addActionListener(this);
        Panel panel = new Panel();
        this.levelWindow = new DPLevelWindow();
        this.levelWindow.setMouseActive(false);
        panel.setLayout(new GridLayout(1, 2));
        panel.add(this.levelWindow);
        panel.add(this.molecularViewer);
        this.setLayout(new BorderLayout());
        this.add("Center", panel);
        this.add("South", this.getToolBar());
        this.setBackground(Color.black);
        this.molecularViewer.setBackground(Color.black);
    }

    public void updateDisplay() {
        double d = this.getSimulator().getTime();
        if (!this.levelWindow.isMouseDown()) {
            double d2 = Math.cos(d / 4.0 * Math.PI);
            double d3 = 360.0 * (d - this.lastTime) / 30.0;
            d2 *= d2;
            this.levelWindow.setEta(d2);
            this.levelWindow.computeDataSet();
            this.levelWindow.refresh();
            if (this.molecule.nAtoms() < 5) {
                float f = (float)((double)2 * d2 / (double)3);
                float f2 = -1.0f - f;
                float f3 = 1.0f - f;
                this.molecule.setAtomPos(1, f2, f3, f3);
                this.molecule.setAtomPos(2, f3, f2, f3);
                this.molecule.setAtomPos(3, f3, f3, f2);
            } else {
                float f = (float)Math.sqrt(1.0 - d2);
                float f4 = (float)Math.sqrt(d2);
                this.molecule.setAtomBrightness(1, f);
                this.molecule.setAtomBrightness(2, f);
                this.molecule.setAtomBrightness(3, f);
                this.molecule.setAtomBrightness(4, f4);
                this.molecule.setAtomBrightness(5, f4);
                this.molecule.setAtomBrightness(6, f4);
            }
            this.molecularViewer.yRot(d3);
            this.molecularViewer.repaint();
        }
        this.lastTime = d;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("TIME")) {
            this.updateDisplay();
        } else if (actionEvent.getActionCommand().equals("PLAY")) {
            this.playButton.setButtonType("PAUSE");
            this.getSimulator().resume();
        } else if (actionEvent.getActionCommand().equals("PAUSE")) {
            this.playButton.setButtonType("PLAY");
            this.getSimulator().pause();
        } else if (actionEvent.getSource() == this.switchButton) {
            if (this.molecule.nAtoms() < 5) {
                this.molecule.setAtomPos(1, -1.0f, 1.0f, 1.0f);
                this.molecule.setAtomPos(2, 1.0f, -1.0f, 1.0f);
                this.molecule.setAtomPos(3, 1.0f, 1.0f, -1.0f);
                this.molecule.addVert("H", -1.6666667f, 0.3333333f, 0.3333333f);
                this.molecule.addVert("H", 0.3333333f, -1.6666667f, 0.3333333f);
                this.molecule.addVert("H", 0.3333333f, 0.3333333f, -1.6666667f);
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.molecule.removeVert(4);
                    this.molecule.setAtomBrightness(i + 1, 1.0f);
                }
            }
        }
    }
}

