/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.acq.DataSrcSupport;
import phy.function.Function;
import phy.util.MathTools;

public class FreeWavePacket
extends DataSrcSupport
implements Function {
    protected double t0 = 0.0;
    protected double width = 1.0;
    protected int displayType = 0;
    protected double k0 = 4.0;

    public void setT0(double d) {
        this.t0 = d;
    }

    public double getT0() {
        return this.t0;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public double getWidth() {
        return this.width;
    }

    public void setDisplayType(int n) {
        this.displayType = n;
    }

    public int getDisplayType() {
        return this.displayType;
    }

    public double getPosition() {
        return (double)2 * this.k0 * (this.getTime() / (double)5 + this.t0);
    }

    public double getValue(double d) {
        double d2 = this.getTime() / (double)5 + this.t0;
        d2 = Math.min(d2, 1.875);
        double d3 = this.width * Math.sqrt(1.0 + MathTools.sqr(d2 / MathTools.sqr(this.width)));
        double d4 = Math.exp(-MathTools.sqr((d - (double)2 * this.k0 * d2) / d3) / (double)2) / d3 * this.width;
        if (this.displayType == 1) {
            d4 = Math.sqrt(d4) * Math.cos(this.k0 * (d - this.k0 * d2) + MathTools.sqr(d - (double)2 * this.k0 * d2) * d2 / MathTools.sqr(d3) / MathTools.sqr(this.width) / (double)4);
        }
        return d4;
    }
}

