/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import phy.graphe.BufferedPanel;
import phy.quanta.FullereneMolecule;

class FullereneViewer
extends BufferedPanel {
    double psi;
    double psi0;
    double psi1;
    double cospsi;
    double sinpsi;
    double xsi;
    double xsi0;
    double xsi1;
    double cosxsi;
    double sinxsi;
    double deltaPsi = 0.0;
    double deltaXsi = 0.05;
    int x0;
    int y0;
    int rayon;
    Point anchor;
    double[] vecteurUnitaire;
    int iVep = 0;
    FullereneMolecule mol;
    String mode = "NORMAL";

    public void setIVep(int n) {
        this.iVep = n;
    }

    public FullereneViewer() {
        this(new FullereneMolecule());
        this.setBackground(Color.green);
        this.mode = "DEMO";
    }

    public FullereneViewer(FullereneMolecule fullereneMolecule) {
        this.mol = fullereneMolecule;
        this.setCursor(new Cursor(12));
        this.xsi = 0.7853981633974483;
        this.psi = 0.2f;
        this.vecteurUnitaire = new double[3];
        this.vecteurUnitaire[0] = 1.0;
        this.vecteurUnitaire[2] = 0.0;
        this.vecteurUnitaire[1] = 0.0;
        this.UpdateSin();
    }

    public void paintCore() {
        Point point;
        int n;
        int n2;
        int n3;
        int n4;
        this.x0 = this.getWidth() / 2;
        this.y0 = this.getHeight() / 2;
        this.rayon = Math.min(this.getWidth() / 3, this.getHeight() / 3) / 3;
        double d = 0.0;
        for (n4 = 0; n4 < this.mol.nAtomes; ++n4) {
            if (!(d < Math.abs(this.mol.vep[n4][this.iVep]))) continue;
            d = Math.abs(this.mol.vep[n4][this.iVep]);
        }
        n4 = this.getSize().width;
        int n5 = this.getSize().height;
        int[] nArray = new int[6];
        int[] nArray2 = new int[6];
        for (n3 = 0; n3 < this.mol.nPolygones; ++n3) {
            if (!this.mol.FaceUp(n3, this.vecteurUnitaire)) continue;
            for (n2 = 0; n2 < 6; ++n2) {
                n = this.mol.polygone[n3][n2];
                point = this.P2D(this.mol.r[n][0], this.mol.r[n][1], this.mol.r[n][2]);
                nArray[n2] = point.x;
                nArray2[n2] = point.y;
            }
            if (this.mol.polygone[n3][0] == this.mol.polygone[n3][5]) {
                if (this.mode.equals("DEMO")) {
                    this.graphics.setColor(Color.black);
                } else {
                    this.graphics.setColor(Color.red);
                }
                this.graphics.getGraphics().fillPolygon(nArray, nArray2, 5);
                continue;
            }
            if (this.mode.equals("DEMO")) {
                this.graphics.setColor(Color.white);
            } else {
                this.graphics.setColor(Color.yellow);
            }
            this.graphics.getGraphics().fillPolygon(nArray, nArray2, 6);
        }
        this.graphics.setColor(Color.black);
        for (n3 = 0; n3 < this.mol.nPolygones; ++n3) {
            int n6;
            int n7;
            if (!this.mol.FaceUp(n3, this.vecteurUnitaire)) continue;
            n2 = 6;
            if (this.mol.polygone[n3][0] == this.mol.polygone[n3][5]) {
                n2 = 5;
            }
            n = 0;
            int n8 = 0;
            for (n7 = 0; n7 < n2; ++n7) {
                n6 = this.mol.polygone[n3][n7];
                point = this.P2D(this.mol.r[n6][0], this.mol.r[n6][1], this.mol.r[n6][2]);
                nArray[n7] = point.x;
                n += point.x;
                nArray2[n7] = point.y;
                n8 += point.y;
            }
            n /= n2;
            n8 /= n2;
            if (d > 0.0) {
                for (n7 = 0; n7 < n2; ++n7) {
                    n6 = this.mol.polygone[n3][n7];
                    int[] nArray3 = new int[4];
                    int[] nArray4 = new int[4];
                    nArray3[0] = nArray[n7];
                    nArray4[0] = nArray2[n7];
                    int n9 = n7 + 1;
                    if (n9 >= n2) {
                        n9 = 0;
                    }
                    nArray3[1] = (nArray[n7] + nArray[n9]) / 2;
                    nArray4[1] = (nArray2[n7] + nArray2[n9]) / 2;
                    nArray3[2] = n;
                    nArray4[2] = n8;
                    n9 = n7 - 1;
                    if (n9 < 0) {
                        n9 = n2 - 1;
                    }
                    nArray3[3] = (nArray[n7] + nArray[n9]) / 2;
                    nArray4[3] = (nArray2[n7] + nArray2[n9]) / 2;
                    if (this.mol.vep[n6][this.iVep] > 0.0) {
                        this.graphics.setColor(new Color((float)Math.abs(this.mol.vep[n6][this.iVep] / d), 0.0f, 0.0f));
                    } else {
                        this.graphics.setColor(new Color(0.0f, (float)Math.abs(this.mol.vep[n6][this.iVep] / d), 0.0f));
                    }
                    this.graphics.getGraphics().fillPolygon(nArray3, nArray4, 4);
                    this.graphics.setColor(this.getForeground());
                    point = this.P2D(this.mol.r[n6][0], this.mol.r[n6][1], this.mol.r[n6][2]);
                    this.graphics.getGraphics().fillOval(point.x - 3, point.y - 3, 6, 6);
                }
            }
            this.graphics.getGraphics().drawPolygon(nArray, nArray2, n2);
        }
    }

    void UpdateSin() {
        this.sinpsi = Math.sin(this.psi * Math.PI);
        this.cospsi = Math.cos(this.psi * Math.PI);
        this.sinxsi = Math.sin(this.xsi);
        this.cosxsi = Math.cos(this.xsi);
        this.vecteurUnitaire[0] = this.cospsi * this.sinxsi;
        this.vecteurUnitaire[1] = this.cospsi * this.cosxsi;
        this.vecteurUnitaire[2] = this.sinpsi;
    }

    void NextAngle() {
        this.psi += this.deltaPsi;
        this.xsi += this.deltaXsi;
        this.UpdateSin();
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.deltaXsi = 0.0;
        this.deltaPsi = 0.0;
        this.anchor = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.psi0 = this.psi1 = this.psi;
        this.xsi0 = this.xsi1 = this.xsi;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.psi = this.psi0 + (double)(mouseEvent.getY() - this.anchor.y) / (6.28 * (double)this.rayon);
        this.xsi = this.xsi0 + (double)(mouseEvent.getX() - this.anchor.x) / (3.0 * (double)this.rayon) * Math.cos(this.psi * Math.PI);
        this.UpdateSin();
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.repaint();
    }

    Point P2D(double d, double d2, double d3) {
        return new Point((int)((double)this.rayon * (-d * this.cosxsi + d2 * this.sinxsi)) + this.x0, -((int)((double)this.rayon * ((-d * this.sinxsi - d2 * this.cosxsi) * this.sinpsi + d3 * this.cospsi))) + this.y0);
    }
}

