/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import phy.util.Point3D;
import phy.util.Vector3D;

public class GerlachApparatus {
    protected Point3D origin;
    protected double distance;
    protected Point3D center;
    protected Vector3D axis;
    protected Vector3D upAxis;
    protected Vector3D downAxis;
    protected Vector3D vertical;
    protected Vector3D field;
    protected double angle;

    public Point3D getCenter() {
        return this.center;
    }

    public void setAxis(Vector3D vector3D) {
        this.axis = vector3D;
        this.update();
    }

    public Vector3D getAxis() {
        return this.axis;
    }

    public Vector3D getUpAxis() {
        return this.upAxis;
    }

    public Vector3D getDownAxis() {
        return this.downAxis;
    }

    public Vector3D getVertical() {
        return this.vertical;
    }

    public Vector3D getField() {
        return this.field;
    }

    public void setAngle(double d) {
        this.angle = d;
        this.update();
    }

    public double getAngle() {
        return this.angle;
    }

    public GerlachApparatus(Vector3D vector3D, Point3D point3D, double d) {
        this.distance = d;
        this.origin = point3D;
        this.axis = vector3D;
        this.update();
    }

    public void update() {
        this.center = Vector3D.sum(this.origin, Point3D.mul(this.axis, this.distance));
        this.vertical = new Vector3D(0.0, 1.0, 0.0);
        this.vertical.orthonormalize(this.axis);
        Vector3D vector3D = Vector3D.vectorialProduct(this.axis, this.vertical);
        Point3D point3D = new Point3D(this.vertical);
        point3D.mul(Math.cos(this.angle));
        Point3D point3D2 = new Point3D(vector3D);
        point3D2.mul(-Math.sin(this.angle));
        this.field = Vector3D.sum(point3D, point3D2);
        point3D = new Point3D(this.axis);
        point3D.mul(Math.cos(0.06283185307179587));
        point3D2 = new Point3D(this.field);
        point3D2.mul(Math.sin(0.06283185307179587));
        this.upAxis = Vector3D.sum(point3D, point3D2);
        this.downAxis = Vector3D.diff(point3D, point3D2);
    }
}

