/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Vector;
import phy.control.HotCurve;
import phy.control.HotSpotVector;
import phy.graphe.BufferedPanel;
import phy.quanta.GerlachApparatus;
import phy.util.Circle3D;
import phy.util.DoublePoint;
import phy.util.Point3D;
import phy.util.Vector3D;

public class GerlachViewer
extends BufferedPanel {
    Vector apparatus = new Vector();
    int prevX;
    int prevY;

    public GerlachViewer() {
        this.graphics.setOrthonorme(true);
        this.graphics.setWindow(-2.0, -1.0, 2.0, 1.0);
        this.apparatus.addElement(new GerlachApparatus(new Vector3D(1.0, 0.0, 0.0), new Point3D(0.0, 0.0, 0.0), 1.0));
        this.apparatus.addElement(new GerlachApparatus(this.getApparatus(0).getUpAxis(), this.getApparatus(0).getCenter(), 1.0));
        this.apparatus.addElement(new GerlachApparatus(this.getApparatus(1).getUpAxis(), this.getApparatus(1).getCenter(), 1.0));
        this.setMouse3D(true);
    }

    public GerlachApparatus getApparatus(int n) {
        return (GerlachApparatus)this.apparatus.elementAt(n);
    }

    public void paintCore() {
        Point3D point3D = new Point3D(0.0, 0.0, 0.0);
        Point3D point3D2 = new Point3D(1.0, 0.0, 0.0);
        Point3D point3D3 = new Point3D(2.0, 0.0, 0.0);
        Point3D point3D4 = new Point3D(4.0, -0.5, -0.5);
        Point3D point3D5 = new Point3D(4.0, -0.5, 0.5);
        Point3D point3D6 = new Point3D(4.0, 0.5, 0.5);
        Point3D point3D7 = new Point3D(4.0, 0.5, -0.5);
        this.graphics.setOrigin3D(point3D3);
        DoublePoint doublePoint = this.graphics.project(point3D);
        DoublePoint doublePoint2 = this.graphics.project(point3D2);
        DoublePoint doublePoint3 = this.graphics.project(point3D4);
        DoublePoint doublePoint4 = this.graphics.project(point3D5);
        DoublePoint doublePoint5 = this.graphics.project(point3D6);
        DoublePoint doublePoint6 = this.graphics.project(point3D7);
        this.graphics.setColor(Color.gray);
        this.graphics.fillPolygon(new DoublePoint[]{doublePoint3, doublePoint4, doublePoint5, doublePoint6});
        this.graphics.setColor(Color.yellow);
        this.graphics.drawLine(doublePoint, doublePoint2);
        for (int i = 0; i < this.apparatus.size(); ++i) {
            GerlachApparatus gerlachApparatus = this.getApparatus(i);
            DoublePoint doublePoint7 = this.graphics.project(gerlachApparatus.getCenter());
            this.graphics.setColor(Color.white);
            this.graphics.fillDisk(doublePoint7, new Integer(3));
            Point3D point3D8 = Point3D.mul(gerlachApparatus.getField(), 0.5);
            DoublePoint doublePoint8 = this.graphics.project(Vector3D.sum(gerlachApparatus.getCenter(), point3D8));
            DoublePoint doublePoint9 = this.graphics.project(Vector3D.diff(gerlachApparatus.getCenter(), point3D8));
            this.graphics.drawArrow(doublePoint9, doublePoint8, 7);
            this.graphics.setColor(Color.yellow);
            this.graphics.drawLine(doublePoint7, this.graphics.project(Vector3D.sum(gerlachApparatus.getCenter(), gerlachApparatus.getUpAxis())));
            this.graphics.drawLine(doublePoint7, this.graphics.project(Vector3D.sum(gerlachApparatus.getCenter(), gerlachApparatus.getDownAxis())));
        }
        this.initHotSpots();
    }

    public void initHotSpots() {
        HotSpotVector hotSpotVector = this.getHotSpotVector();
        hotSpotVector.removeAllElements();
        Circle3D circle3D = new Circle3D(this.getApparatus(0).getCenter(), this.getApparatus(0).getAxis(), this.getApparatus(0).getVertical(), 0.5, 50);
        hotSpotVector.addElement(new HotCurve(this.graphics.screenProject(circle3D), this.getApparatus(0).getAngle() / (double)2 / Math.PI));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.prevX = this.getXMouse();
        this.prevY = this.getYMouse();
    }

    public void mouseDragged() {
        super.mouseDragged();
        if (this.getCurrentHotSpot() != null) {
            this.getApparatus(0).setAngle(((HotCurve)this.getCurrentHotSpot()).getAbscisse() * (double)2 * Math.PI);
            this.getApparatus(1).setAxis(this.getApparatus(0).getUpAxis());
            this.getApparatus(2).update();
            this.repaint();
        }
    }
}

