/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import phy.control.DoubleValueDisplay;
import phy.control.NavigationPanel;
import phy.control.PhySeparator;
import phy.graphe.BufferedPanel;
import phy.graphe.DrawableEquation;
import phy.quanta.HarmonicAbstract;
import phy.quanta.HarmonicOscillator;
import phy.quanta.HarmonicViewerGauge;
import phy.quanta.HarmonicViewerPotential;
import phy.quanta.HarmonicViewerProba;
import phy.util.AbsoluteLayout;

public class Harmonic
extends HarmonicAbstract {
    public void init() {
        super.init();
        this.oscillator = new HarmonicOscillator();
        this.initSimulator();
        this.getSimulator().setDataSrc(this.oscillator);
        this.getSimulator().pause();
        this.initPlayButton();
        this.setToolBar(new NavigationPanel());
        this.getToolBar().add(this.getPlayButton());
        this.getToolBar().add(new PhySeparator());
        DoubleValueDisplay doubleValueDisplay = new DoubleValueDisplay(this.oscillator, "MeanEnergy", "<E>=%5.2f \\hbar \\omega");
        this.getToolBar().add(doubleValueDisplay);
        HarmonicViewerProba harmonicViewerProba = new HarmonicViewerProba(this.oscillator);
        this.viewerPotential = new HarmonicViewerPotential(this.getSimulator());
        this.viewerPotential.setName("Potential");
        this.viewerGauge = new HarmonicViewerGauge(this.getSimulator());
        this.viewerGauge.setName("Gauge");
        this.viewerEquation = new BufferedPanel();
        this.viewerEquation.addDrawableObject("EQ1", new DrawableEquation("\\psi(x,t)=\\Sigma C_n exp(-iE_nt/\\hbar) \\phi_n(x)", new Point(25, 15), 4));
        this.viewerEquation.setName("Equation");
        this.setLayout(new AbsoluteLayout());
        int n = 400;
        int n2 = 230;
        int n3 = 38;
        int n4 = 31;
        this.add((Component)this.viewerPotential, new Rectangle(0, 0, n, n2));
        this.add((Component)harmonicViewerProba, new Rectangle(0, n2 + 1, n, n3));
        this.add((Component)this.viewerGauge, new Rectangle(n + 1, 0, 199, n2));
        this.add((Component)this.viewerEquation, new Rectangle(n + 1, n2 + 1, 199, n3));
        this.add((Component)this.getToolBar(), new Rectangle(0, n2 + n3 + 1, 600, n4));
        this.getSimulator().addObserver(harmonicViewerProba);
        this.getSimulator().addObserver(this.viewerPotential);
        this.getSimulator().addObserver(this.viewerGauge);
    }
}

