/*
 * Decompiled with CFR 0.152.
 */
package phy.quanta;

import java.awt.event.ActionEvent;
import phy.graphe.BufferedPanel;
import phy.quanta.HarmonicOscillator;
import phy.quanta.HarmonicViewerGauge;
import phy.quanta.HarmonicViewerPotential;
import phy.quanta.QuantaApplet;
import phy.util.CrackedString;

public class HarmonicAbstract
extends QuantaApplet {
    protected HarmonicOscillator oscillator;
    protected HarmonicViewerGauge viewerGauge;
    protected HarmonicViewerPotential viewerPotential;
    protected BufferedPanel viewerEquation;

    public HarmonicOscillator getOscillator() {
        return this.oscillator;
    }

    public HarmonicViewerGauge getViewerGauge() {
        return this.viewerGauge;
    }

    public HarmonicViewerPotential getViewerPotential() {
        return this.viewerPotential;
    }

    public BufferedPanel getViewerEquation() {
        return this.viewerEquation;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("SHOW HISTO")) {
            this.viewerGauge.setVisible(true);
            this.validate();
        } else if (actionEvent.getActionCommand().startsWith("CAT ")) {
            int n = CrackedString.getInt(actionEvent.getActionCommand(), 1);
            for (int i = 0; i < this.oscillator.getNNiveaux(); ++i) {
                this.oscillator.weight[i] = i % 2 == 0 && i < 2 * n + 1 ? 1.0 / Math.sqrt(n + 1) : 0.0;
            }
            this.oscillator.computeProba();
            this.getSimulator().informObservers();
        } else if (actionEvent.getActionCommand().startsWith("NLEVELS ")) {
            this.viewerPotential.setNLevelsShown(CrackedString.getInt(actionEvent.getActionCommand(), 1));
            this.viewerPotential.repaint();
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

